/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.config.internal.MergeableNode;
import io.helidon.config.spi.ConfigNode;
import java.util.Objects;

public class ValueNodeImpl
implements ConfigNode.ValueNode,
MergeableNode {
    private final String value;
    private String description;

    public ValueNodeImpl(String value) {
        this.value = value;
        this.description = null;
    }

    @Override
    public String get() {
        return this.value;
    }

    static ValueNodeImpl wrap(ConfigNode.ValueNode valueNode) {
        if (valueNode instanceof ValueNodeImpl) {
            return (ValueNodeImpl)valueNode;
        }
        return new ValueNodeImpl((String)valueNode.get());
    }

    @Override
    public MergeableNode merge(MergeableNode node) {
        switch (node.getNodeType()) {
            case OBJECT: {
                return node.merge(this);
            }
            case LIST: {
                return node.merge(this);
            }
            case VALUE: {
                return node;
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueNodeImpl valueNode = (ValueNodeImpl)o;
        return Objects.equals(this.value, valueNode.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public ValueNodeImpl initDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean hasValue() {
        return true;
    }
}

