/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.config.internal.ConfigUtils;
import io.helidon.config.internal.ListNodeBuilderImpl;
import io.helidon.config.internal.ObjectNodeBuilderImpl;
import io.helidon.config.internal.ValueNodeImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface ConfigNode
extends Supplier<String> {
    public NodeType getNodeType();

    public static interface ObjectNode
    extends ConfigNode,
    Map<String, ConfigNode> {
        @Override
        default public NodeType getNodeType() {
            return NodeType.OBJECT;
        }

        public static ObjectNode empty() {
            return ConfigUtils.EmptyObjectNodeHolder.EMPTY;
        }

        public static Builder builder() {
            return new ObjectNodeBuilderImpl();
        }

        public static interface Builder {
            default public Builder addValue(String key, String value) {
                return this.addValue(key, ValueNode.from(value));
            }

            public Builder addValue(String var1, ValueNode var2);

            public Builder addObject(String var1, ObjectNode var2);

            public Builder addList(String var1, ListNode var2);

            public Builder value(String var1);

            public ObjectNode build();
        }
    }

    public static interface ListNode
    extends ConfigNode,
    List<ConfigNode> {
        @Override
        default public NodeType getNodeType() {
            return NodeType.LIST;
        }

        public static Builder builder() {
            return new ListNodeBuilderImpl();
        }

        public static interface Builder {
            default public Builder addValue(String value) {
                return this.addValue(ValueNode.from(value));
            }

            public Builder addValue(ValueNode var1);

            public Builder addObject(ObjectNode var1);

            public Builder addList(ListNode var1);

            public Builder value(String var1);

            public ListNode build();
        }
    }

    public static interface ValueNode
    extends ConfigNode {
        @Override
        default public NodeType getNodeType() {
            return NodeType.VALUE;
        }

        public static ValueNode from(String value) {
            return new ValueNodeImpl(value);
        }
    }

    public static enum NodeType {
        OBJECT,
        LIST,
        VALUE;

    }
}

