/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.config.ConfigException;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParserException;
import java.util.Optional;
import java.util.Set;

public interface ConfigParser {
    public static final int PRIORITY = 100;

    public Set<String> getSupportedMediaTypes();

    public <S> ConfigNode.ObjectNode parse(Content<S> var1) throws ConfigParserException;

    public static interface Content<S> {
        default public void close() throws ConfigException {
        }

        default public Optional<S> getStamp() {
            return Optional.empty();
        }

        public String getMediaType();

        public <T extends Readable & AutoCloseable> T asReadable();

        public static <S> Content<S> from(final Readable readable, final String mediaType, final Optional<S> stamp) {
            return new Content<S>(){

                @Override
                public void close() throws ConfigException {
                    if (readable instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)((Object)readable)).close();
                        }
                        catch (ConfigException ex) {
                            throw ex;
                        }
                        catch (Exception ex) {
                            throw new ConfigException("Error while closing readable [" + readable + "].", ex);
                        }
                    }
                }

                @Override
                public <T extends Readable & AutoCloseable> T asReadable() {
                    return (T)readable;
                }

                @Override
                public String getMediaType() {
                    return mediaType;
                }

                @Override
                public Optional<S> getStamp() {
                    return stamp;
                }
            };
        }
    }
}

