/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.config.spi.OrderedProperties;
import io.helidon.config.spi.Source;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface OverrideSource
extends Source<OverrideData>,
Supplier<OverrideSource> {
    @Override
    default public OverrideSource get() {
        return this;
    }

    public static final class OverrideData {
        static final Function<String, Predicate<Config.Key>> WILDCARDS_TO_PREDICATE = s -> key -> Pattern.compile(s.replace("*", "\\w+").replace(".", "\\.")).matcher(key.toString()).matches();
        private List<Map.Entry<Predicate<Config.Key>, String>> data = new ArrayList<Map.Entry<Predicate<Config.Key>, String>>();

        private OverrideData(List<Map.Entry<Predicate<Config.Key>, String>> data) {
            this.data = data;
        }

        public static OverrideData from(List<Map.Entry<Predicate<Config.Key>, String>> data) {
            return new OverrideData(data);
        }

        public static OverrideData fromWildcards(List<Map.Entry<String, String>> wildcards) {
            List<Map.Entry<Predicate<Config.Key>, String>> overrides = wildcards.stream().map(e -> new AbstractMap.SimpleEntry<Predicate<Config.Key>, String>(WILDCARDS_TO_PREDICATE.apply((String)e.getKey()), (String)e.getValue())).collect(Collectors.toList());
            return new OverrideData(overrides);
        }

        public static OverrideData from(Reader reader) throws IOException {
            OrderedProperties properties = new OrderedProperties();
            try (Reader autocloseableReader = reader;){
                properties.load(autocloseableReader);
            }
            List<Map.Entry<Predicate<Config.Key>, String>> data = properties.getOrderedMap().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<Predicate<Config.Key>, String>(WILDCARDS_TO_PREDICATE.apply((String)e.getKey()), (String)e.getValue())).collect(Collectors.toList());
            return OverrideData.from(data);
        }

        public static OverrideData empty() {
            return new OverrideData(CollectionsHelper.listOf());
        }

        public List<Map.Entry<Predicate<Config.Key>, String>> data() {
            return this.data;
        }
    }
}

