/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.common.reactive.Flow;
import java.time.Instant;
import java.util.function.Supplier;

public interface PollingStrategy
extends Supplier<PollingStrategy> {
    @Override
    default public PollingStrategy get() {
        return this;
    }

    public Flow.Publisher<PollingEvent> ticks();

    public static interface PollingEvent {
        public Instant getTimestamp();

        public static PollingEvent now() {
            final Instant timestamp = Instant.now();
            return new PollingEvent(){

                @Override
                public Instant getTimestamp() {
                    return timestamp;
                }

                public String toString() {
                    return "PollingEvent @ " + timestamp;
                }
            };
        }
    }
}

