/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.common.OptionalHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigMapper;
import io.helidon.config.ConfigMappers;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.RetryPolicies;
import io.helidon.config.spi.RetryPolicy;
import java.util.Optional;

class RetryPolicyConfigMapper
implements ConfigMapper<RetryPolicy> {
    private static final String PROPERTIES_KEY = "properties";
    private static final String TYPE_KEY = "type";
    private static final String CLASS_KEY = "class";
    private static final String REPEAT_TYPE = "repeat";

    RetryPolicyConfigMapper() {
    }

    static RetryPolicyConfigMapper instance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public RetryPolicy apply(Config config) throws ConfigMappingException, MissingValueException {
        Config properties = config.get(PROPERTIES_KEY).node().orElse(Config.empty());
        return (RetryPolicy)OptionalHelper.from(config.get(TYPE_KEY).asOptionalString().flatMap(type -> this.builtin((String)type, properties))).or(() -> config.get(CLASS_KEY).asOptional(Class.class).flatMap(clazz -> this.custom((Class<?>)clazz, properties))).asOptional().orElseThrow(() -> new ConfigMappingException(config.key(), "Uncompleted retry-policy configuration."));
    }

    private Optional<RetryPolicy> builtin(String type, Config properties) {
        RetryPolicy retryPolicy;
        switch (type) {
            case "repeat": {
                retryPolicy = properties.as(RetryPolicies.Builder.class).get();
                break;
            }
            default: {
                retryPolicy = null;
            }
        }
        return Optional.ofNullable(retryPolicy);
    }

    private Optional<RetryPolicy> custom(Class<?> clazz, Config properties) {
        RetryPolicy retryPolicy = RetryPolicy.class.isAssignableFrom(clazz) ? (RetryPolicy)properties.as(clazz) : properties.map(ConfigMappers.from(RetryPolicy.class, clazz));
        return Optional.of(retryPolicy);
    }

    static class SingletonHolder {
        private static final RetryPolicyConfigMapper INSTANCE = new RetryPolicyConfigMapper();

        SingletonHolder() {
        }
    }
}

