/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.metrics;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import io.jooby.Context;
import io.jooby.Route;
import io.jooby.StatusCode;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class HealthCheckHandler
implements Route.Handler {
    @Nonnull
    public Object apply(@Nonnull Context ctx) {
        HealthCheckRegistry registry = (HealthCheckRegistry)ctx.require(HealthCheckRegistry.class);
        SortedMap checks = ctx.query("name").toOptional().map(name -> {
            TreeMap<String, HealthCheck.Result> map = new TreeMap<String, HealthCheck.Result>();
            map.put((String)name, registry.runHealthCheck(name));
            return map;
        }).orElseGet(() -> ((HealthCheckRegistry)registry).runHealthChecks());
        ctx.setResponseCode(checks.isEmpty() ? StatusCode.NOT_IMPLEMENTED : checks.values().stream().filter(it -> !it.isHealthy()).findFirst().map(it -> StatusCode.SERVER_ERROR).orElse(StatusCode.OK));
        ctx.setResponseHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        return checks;
    }
}

