/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.jooby.Route;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class MetricsDecorator
implements Route.Decorator {
    @Nonnull
    public Route.Handler apply(@Nonnull Route.Handler next) {
        return (Route.Handler & Serializable)ctx -> {
            MetricRegistry registry = (MetricRegistry)ctx.require(MetricRegistry.class);
            Counter counter = registry.counter("request.actives");
            Timer.Context timer = registry.timer("request").time();
            counter.inc();
            ctx.onComplete(context -> {
                timer.stop();
                counter.dec();
                registry.meter("responses." + context.getResponseCode().value()).mark();
            });
            return next.apply(ctx);
        };
    }
}

