/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.typesafe.config.Config;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.ServiceRegistry;
import io.jooby.metrics.HealthCheckHandler;
import io.jooby.metrics.MetricHandler;
import io.jooby.metrics.PingHandler;
import io.jooby.metrics.ThreadDumpHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class MetricsModule
implements Extension {
    static final String CACHE_HEADER_NAME = "Cache-Control";
    static final String CACHE_HEADER_VALUE = "must-revalidate,no-cache,no-store";
    private final String pattern;
    private final List<Consumer<Router>> routes = new ArrayList<Consumer<Router>>();
    private final Map<String, Metric> metrics = new LinkedHashMap<String, Metric>();
    private final Map<String, Class<? extends Metric>> metricClasses = new LinkedHashMap<String, Class<? extends Metric>>();
    private final Map<String, HealthCheck> healthChecks = new LinkedHashMap<String, HealthCheck>();
    private final Map<String, Class<? extends HealthCheck>> healthCheckClasses = new LinkedHashMap<String, Class<? extends HealthCheck>>();
    private final Set<BiFunction<MetricRegistry, Config, Reporter>> reporters = new LinkedHashSet<BiFunction<MetricRegistry, Config, Reporter>>();
    private final MetricRegistry metricRegistry;
    private final HealthCheckRegistry healthCheckRegistry;

    public MetricsModule(MetricRegistry metricRegistry, HealthCheckRegistry healthCheckRegistry, String pattern) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry is required.");
        this.healthCheckRegistry = Objects.requireNonNull(healthCheckRegistry, "Health check registry is required.");
        this.pattern = Objects.requireNonNull(pattern, "A pattern is required.");
    }

    public MetricsModule(MetricRegistry metricRegistry, HealthCheckRegistry healthCheckRegistry) {
        this(metricRegistry, healthCheckRegistry, "/sys");
    }

    public MetricsModule(MetricRegistry metricRegistry, String pattern) {
        this(metricRegistry, new HealthCheckRegistry(), pattern);
    }

    public MetricsModule(String pattern) {
        this(new MetricRegistry(), pattern);
    }

    public MetricsModule(HealthCheckRegistry healthCheckRegistry) {
        this(new MetricRegistry(), healthCheckRegistry, "/sys");
    }

    public MetricsModule(MetricRegistry metricRegistry) {
        this(metricRegistry, "/sys");
    }

    public MetricsModule() {
        this("/sys");
    }

    public MetricsModule ping() {
        this.routes.add(router -> router.get(this.pattern + "/ping", (Route.Handler)new PingHandler()));
        return this;
    }

    public MetricsModule threadDump() {
        this.routes.add(router -> router.get(this.pattern + "/thread-dump", (Route.Handler)new ThreadDumpHandler()));
        return this;
    }

    public MetricsModule metric(String name, Metric metric) {
        this.metrics.put(name, metric);
        return this;
    }

    public <M extends Metric> MetricsModule metric(String name, Class<M> metric) {
        this.metricClasses.put(name, metric);
        return this;
    }

    public MetricsModule healthCheck(String name, HealthCheck check) {
        this.healthChecks.put(name, check);
        return this;
    }

    public <H extends HealthCheck> MetricsModule healthCheck(String name, Class<H> check) {
        this.healthCheckClasses.put(name, check);
        return this;
    }

    public MetricsModule reporter(BiFunction<MetricRegistry, Config, Reporter> callback) {
        this.reporters.add(Objects.requireNonNull(callback, "Callback is required."));
        return this;
    }

    public MetricsModule reporter(Function<MetricRegistry, Reporter> callback) {
        return this.reporter((MetricRegistry registry, Config conf) -> (Reporter)callback.apply((MetricRegistry)registry));
    }

    public void install(@Nonnull Jooby application) {
        MetricHandler metricHandler = new MetricHandler();
        application.get(this.pattern + "/metrics", (Route.Handler)metricHandler);
        application.get(this.pattern + "/metrics/:type", (Route.Handler)metricHandler);
        application.get(this.pattern + "/healthcheck", (Route.Handler)new HealthCheckHandler());
        this.routes.forEach(r -> r.accept(application));
        ServiceRegistry registry = application.getServices();
        registry.putIfAbsent(MetricRegistry.class, (Object)this.metricRegistry);
        registry.putIfAbsent(HealthCheckRegistry.class, (Object)this.healthCheckRegistry);
        this.metrics.forEach((arg_0, arg_1) -> ((MetricRegistry)this.metricRegistry).register(arg_0, arg_1));
        this.healthChecks.forEach((arg_0, arg_1) -> ((HealthCheckRegistry)this.healthCheckRegistry).register(arg_0, arg_1));
        HashSet reporters = new HashSet();
        application.onStarted(() -> {
            this.metricClasses.forEach((name, clazz) -> this.metricRegistry.register(name, (Metric)application.require(clazz)));
            this.healthCheckClasses.forEach((name, clazz) -> this.healthCheckRegistry.register(name, (HealthCheck)application.require(clazz)));
            Config config = application.getConfig();
            this.reporters.stream().map(r -> (Reporter)r.apply(this.metricRegistry, config)).filter(Objects::nonNull).forEachOrdered(reporters::add);
        });
        application.onStop(() -> reporters.forEach(r -> {
            try {
                r.close();
            }
            catch (IOException e) {
                application.getLog().error("close of {} resulted in error", r, (Object)e);
            }
        }));
    }
}

