/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.metrics;

import com.codahale.metrics.jvm.ThreadDump;
import io.jooby.Context;
import io.jooby.MediaType;
import io.jooby.Route;
import io.jooby.StatusCode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumpHandler
implements Route.Handler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ThreadDump threadDump;

    public ThreadDumpHandler() {
        try {
            this.threadDump = new ThreadDump(ManagementFactory.getThreadMXBean());
        }
        catch (Exception ex) {
            this.log.warn("Thread dump isn't available", (Throwable)ex);
        }
    }

    @Nonnull
    public Object apply(@Nonnull Context ctx) {
        Object data;
        if (this.threadDump == null) {
            data = "Sorry your runtime environment does not allow to dump threads.";
            ctx.setResponseCode(StatusCode.NOT_IMPLEMENTED);
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.threadDump.dump((OutputStream)output);
            data = output.toByteArray();
        }
        ctx.setResponseType(MediaType.text);
        ctx.setResponseHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        return data;
    }
}

