/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import java.util.Objects;
import java.util.Optional;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.AllowableValues;

public class ModelRef
implements ModelReference {
    private final String type;
    private final Optional<String> typeSignature;
    private final boolean isMap;
    private final Optional<ModelReference> itemModel;
    private final Optional<AllowableValues> allowableValues;
    private final Optional<String> modelId;

    public ModelRef(String type) {
        this(type, null, null, null, null);
    }

    public ModelRef(String type, ModelReference itemType) {
        this(type, itemType, false);
    }

    public ModelRef(String type, String typeSignature, ModelReference itemType, AllowableValues allowableValues, String modelId) {
        this(type, typeSignature, itemType, allowableValues, false, modelId);
    }

    public ModelRef(String type, AllowableValues allowableValues) {
        this(type, null, null, allowableValues, null);
    }

    public ModelRef(String type, ModelReference itemType, boolean isMap) {
        this(type, null, itemType, null, isMap, null);
    }

    public ModelRef(String type, String typeSignature, ModelReference itemModel, AllowableValues allowableValues, boolean isMap, String modelId) {
        this.type = type;
        this.typeSignature = Optional.ofNullable(typeSignature);
        this.isMap = isMap;
        this.allowableValues = Optional.ofNullable(allowableValues);
        this.itemModel = Optional.ofNullable(itemModel);
        this.modelId = Optional.ofNullable(modelId);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Optional<String> getTypeSignature() {
        return this.typeSignature;
    }

    @Override
    public boolean isCollection() {
        return this.itemModel.isPresent() && !this.isMap;
    }

    @Override
    public boolean isMap() {
        return this.itemModel.isPresent() && this.isMap;
    }

    @Override
    public String getItemType() {
        return this.itemModel.map(ModelReference::getType).orElse(null);
    }

    @Override
    public AllowableValues getAllowableValues() {
        return this.allowableValues.orElse(null);
    }

    @Override
    public Optional<ModelReference> itemModel() {
        return this.itemModel;
    }

    @Override
    public Optional<String> getModelId() {
        return this.modelId;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.typeSignature, this.isMap, this.itemModel, this.allowableValues, this.modelId.isPresent());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelRef that = (ModelRef)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.typeSignature, that.typeSignature) && Objects.equals(this.isMap, that.isMap) && Objects.equals(this.itemModel, that.itemModel) && Objects.equals(this.allowableValues, that.allowableValues) && Objects.equals(this.modelId, that.modelId);
    }
}

