/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import scala_maven.FileUtils;
import scala_maven.ScalaCompilerSupport;
import scala_maven_executions.JavaMainCaller;

@Mojo(name="cc", requiresDependencyResolution=ResolutionScope.TEST)
public class ScalaContinuousCompileMojo
extends ScalaCompilerSupport {
    @Parameter(property="project.build.outputDirectory")
    private File mainOutputDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}/../scala")
    private File mainSourceDir;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testOutputDir;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../scala")
    private File testSourceDir;
    @Parameter(property="analysisCacheFile", defaultValue="${project.build.directory}/analysis/compile")
    private File analysisCacheFile;
    @Parameter(property="testAnalysisCacheFile", defaultValue="${project.build.directory}/analysis/test-compile")
    private File testAnalysisCacheFile;
    @Parameter(property="fsc", defaultValue="true")
    private boolean useFsc;
    @Parameter(property="once", defaultValue="false")
    private boolean once;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;

    @Override
    protected List<String> getClasspathElements() {
        throw new UnsupportedOperationException("USELESS");
    }

    @Override
    protected File getOutputDir() {
        throw new UnsupportedOperationException("USELESS");
    }

    @Override
    protected List<File> getSourceDirectories() {
        throw new UnsupportedOperationException("USELESS");
    }

    @Override
    protected File getAnalysisCacheFile() {
        throw new UnsupportedOperationException("USELESS");
    }

    @Override
    protected JavaMainCaller getScalaCommand() throws Exception {
        JavaMainCaller jcmd = super.getScalaCommand();
        if (this.useFsc && this.verbose) {
            jcmd.addOption("-verbose", true);
        }
        return jcmd;
    }

    @Override
    protected final void doExecute() throws Exception {
        this.mainOutputDir = FileUtils.fileOf(this.mainOutputDir, this.useCanonicalPath);
        if (!this.mainOutputDir.exists()) {
            this.mainOutputDir.mkdirs();
        }
        ArrayList<String> mainSources = new ArrayList<String>(this.project.getCompileSourceRoots());
        mainSources.add(FileUtils.pathOf(this.mainSourceDir, this.useCanonicalPath));
        List<File> mainSourceDirs = this.normalize(mainSources);
        this.testOutputDir = FileUtils.fileOf(this.testOutputDir, this.useCanonicalPath);
        if (!this.testOutputDir.exists()) {
            this.testOutputDir.mkdirs();
        }
        ArrayList<String> testSources = new ArrayList<String>(this.project.getTestCompileSourceRoots());
        testSources.add(FileUtils.pathOf(this.testSourceDir, this.useCanonicalPath));
        List<File> testSourceDirs = this.normalize(testSources);
        this.analysisCacheFile = FileUtils.fileOf(this.analysisCacheFile, this.useCanonicalPath);
        this.testAnalysisCacheFile = FileUtils.fileOf(this.testAnalysisCacheFile, this.useCanonicalPath);
        if (this.useFsc && this.recompileMode != ScalaCompilerSupport.RecompileMode.incremental) {
            this.getLog().info((CharSequence)"use fsc for compilation");
            this.scalaClassName = "scala.tools.nsc.CompileClient";
            if (!this.once) {
                StopServer stopServer = new StopServer();
                stopServer.run();
                this.startNewCompileServer();
                Runtime.getRuntime().addShutdownHook(stopServer);
            } else {
                this.startNewCompileServer();
            }
        }
        this.getLog().info((CharSequence)"wait for files to compile...");
        do {
            this.clearCompileErrors();
            int nbFile = 0;
            if (!mainSourceDirs.isEmpty() && (nbFile = this.compile(mainSourceDirs, this.mainOutputDir, this.analysisCacheFile, this.project.getCompileClasspathElements(), true)) == -1) {
                nbFile = 0;
            }
            if (!testSourceDirs.isEmpty()) {
                nbFile += this.compile(testSourceDirs, this.testOutputDir, this.testAnalysisCacheFile, this.project.getTestClasspathElements(), true);
            }
            if (nbFile > 0) {
                if (!this.hasCompileErrors()) {
                    this.postCompileActions();
                } else {
                    this.getLog().info((CharSequence)"Not running test cases due to compile error");
                }
            }
            if (this.once) continue;
            if (nbFile > 0) {
                this.getLog().info((CharSequence)"wait for files to compile...");
                Thread.sleep(5000L);
                continue;
            }
            Thread.sleep(3000L);
        } while (!this.once);
    }

    protected void postCompileActions() throws Exception {
    }

    private void startNewCompileServer() throws Exception {
        File serverTagFile = new File(this.mainOutputDir + ".server");
        if (serverTagFile.exists()) {
            return;
        }
        this.getLog().info((CharSequence)"start server...");
        JavaMainCaller jcmd = this.getEmptyScalaCommand("scala.tools.nsc.MainGenericRunner");
        jcmd.addArgs("scala.tools.nsc.CompileServer");
        jcmd.addJvmArgs(this.jvmArgs);
        jcmd.addArgs(this.args);
        jcmd.spawn(this.displayCmd);
        FileUtils.fileWrite((String)serverTagFile.getAbsolutePath(), (String)".");
        Thread.sleep(1000L);
    }

    private class StopServer
    extends Thread {
        private StopServer() {
        }

        @Override
        public void run() {
            try {
                ScalaContinuousCompileMojo.this.getLog().info((CharSequence)"stop server(s)...");
                JavaMainCaller jcmd = ScalaContinuousCompileMojo.this.getScalaCommand();
                jcmd.addArgs("-shutdown");
                jcmd.run(ScalaContinuousCompileMojo.this.displayCmd, false);
                File serverTagFile = new File(ScalaContinuousCompileMojo.this.mainOutputDir + ".server");
                if (serverTagFile.exists()) {
                    serverTagFile.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

