/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.exceptions.InvalidRequestException;

public class DropIndexStatement {
    public final String indexName;
    private String keyspace;

    public DropIndexStatement(String indexName) {
        this.indexName = indexName;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getColumnFamily() throws InvalidRequestException {
        return this.findIndexedCF().cfName;
    }

    public CFMetaData generateCFMetadataUpdate() throws InvalidRequestException {
        return this.updateCFMetadata(this.findIndexedCF());
    }

    private CFMetaData updateCFMetadata(CFMetaData cfm) {
        ColumnDefinition column = this.findIndexedColumn(cfm);
        assert (column != null);
        CFMetaData cloned = cfm.clone();
        ColumnDefinition toChange = cloned.getColumnDefinition(column.name);
        assert (toChange.getIndexName() != null && toChange.getIndexName().equals(this.indexName));
        toChange.setIndexName(null);
        toChange.setIndexType(null, null);
        return cloned;
    }

    private CFMetaData findIndexedCF() throws InvalidRequestException {
        KSMetaData ksm = Schema.instance.getKSMetaData(this.keyspace);
        for (CFMetaData cfm : ksm.cfMetaData().values()) {
            if (this.findIndexedColumn(cfm) == null) continue;
            return cfm;
        }
        throw new InvalidRequestException("Index '" + this.indexName + "' could not be found in any of the column families of keyspace '" + this.keyspace + "'");
    }

    private ColumnDefinition findIndexedColumn(CFMetaData cfm) {
        for (ColumnDefinition column : cfm.regularColumns()) {
            if (column.getIndexType() == null || column.getIndexName() == null || !column.getIndexName().equals(this.indexName)) continue;
            return column;
        }
        return null;
    }
}

