/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.EmptyColumns;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.PrecompactedRow;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.ColumnNameHelper;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.StreamingHistogram;

public class LazilyCompactedRow
extends AbstractCompactedRow
implements Iterable<OnDiskAtom> {
    private final List<? extends OnDiskAtomIterator> rows;
    private final CompactionController controller;
    private final boolean shouldPurge;
    private final ColumnFamily emptyColumnFamily;
    private Reducer reducer;
    private ColumnStats columnStats;
    private boolean closed;
    private ColumnIndex.Builder indexBuilder;
    private final SecondaryIndexManager.Updater indexer;
    private DeletionTime maxRowTombstone;

    public LazilyCompactedRow(CompactionController controller, List<? extends OnDiskAtomIterator> rows) {
        super(rows.get(0).getKey());
        this.rows = rows;
        this.controller = controller;
        this.indexer = controller.cfs.indexManager.updaterFor(this.key);
        this.maxRowTombstone = DeletionTime.LIVE;
        for (OnDiskAtomIterator onDiskAtomIterator : rows) {
            DeletionTime rowTombstone = onDiskAtomIterator.getColumnFamily().deletionInfo().getTopLevelDeletion();
            if (this.maxRowTombstone.compareTo(rowTombstone) >= 0) continue;
            this.maxRowTombstone = rowTombstone;
        }
        this.shouldPurge = controller.shouldPurge(this.key, Long.MAX_VALUE);
        this.emptyColumnFamily = EmptyColumns.factory.create(controller.cfs.metadata);
        this.emptyColumnFamily.delete(this.maxRowTombstone);
        if (this.shouldPurge) {
            this.emptyColumnFamily.purgeTombstones(controller.gcBefore);
        }
    }

    @Override
    public RowIndexEntry write(long currentPosition, DataOutput out) throws IOException {
        ColumnIndex columnsIndex;
        assert (!this.closed);
        try {
            this.indexBuilder = new ColumnIndex.Builder(this.emptyColumnFamily, this.key.key, out);
            columnsIndex = this.indexBuilder.buildForCompaction(this.iterator());
            if (columnsIndex.columnsIndex.isEmpty() && !this.emptyColumnFamily.isMarkedForDelete()) {
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.columnStats = new ColumnStats(this.reducer == null ? 0 : this.reducer.columns, this.reducer == null ? Long.MAX_VALUE : this.reducer.minTimestampSeen, this.reducer == null ? this.emptyColumnFamily.maxTimestamp() : Math.max(this.emptyColumnFamily.maxTimestamp(), this.reducer.maxTimestampSeen), this.reducer == null ? Integer.MIN_VALUE : this.reducer.maxLocalDeletionTimeSeen, this.reducer == null ? new StreamingHistogram(100) : this.reducer.tombstones, this.reducer == null ? Collections.emptyList() : this.reducer.minColumnNameSeen, this.reducer == null ? Collections.emptyList() : this.reducer.maxColumnNameSeen);
        this.reducer = null;
        this.indexBuilder.maybeWriteEmptyRowHeader();
        out.writeShort(0);
        this.close();
        return RowIndexEntry.create(currentPosition, this.emptyColumnFamily.deletionInfo().getTopLevelDeletion(), columnsIndex);
    }

    @Override
    public void update(MessageDigest digest) {
        assert (!this.closed);
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            DeletionTime.serializer.serialize(this.emptyColumnFamily.deletionInfo().getTopLevelDeletion(), out);
            digest.update(out.getData(), 0, out.getLength());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.indexBuilder = new ColumnIndex.Builder(this.emptyColumnFamily, this.key.key, out);
        Iterator<OnDiskAtom> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next().updateDigest(digest);
        }
        this.close();
    }

    public AbstractType<?> getComparator() {
        return this.emptyColumnFamily.getComparator();
    }

    @Override
    public Iterator<OnDiskAtom> iterator() {
        this.reducer = new Reducer();
        IMergeIterator<OnDiskAtom, OnDiskAtom> iter = MergeIterator.get(this.rows, this.getComparator().onDiskAtomComparator, this.reducer);
        return Iterators.filter(iter, (Predicate)Predicates.notNull());
    }

    @Override
    public ColumnStats columnStats() {
        return this.columnStats;
    }

    @Override
    public void close() {
        for (OnDiskAtomIterator onDiskAtomIterator : this.rows) {
            try {
                onDiskAtomIterator.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.closed = true;
    }

    private class Reducer
    extends MergeIterator.Reducer<OnDiskAtom, OnDiskAtom> {
        final ColumnFamily container;
        RangeTombstone tombstone;
        int columns;
        long minTimestampSeen;
        long maxTimestampSeen;
        int maxLocalDeletionTimeSeen;
        StreamingHistogram tombstones;
        List<ByteBuffer> minColumnNameSeen;
        List<ByteBuffer> maxColumnNameSeen;

        private Reducer() {
            this.container = ArrayBackedSortedColumns.factory.create(LazilyCompactedRow.this.emptyColumnFamily.metadata());
            this.columns = 0;
            this.minTimestampSeen = Long.MAX_VALUE;
            this.maxTimestampSeen = Long.MIN_VALUE;
            this.maxLocalDeletionTimeSeen = Integer.MIN_VALUE;
            this.tombstones = new StreamingHistogram(100);
            this.minColumnNameSeen = Collections.emptyList();
            this.maxColumnNameSeen = Collections.emptyList();
        }

        @Override
        public void reduce(OnDiskAtom current) {
            if (current instanceof RangeTombstone) {
                if (this.tombstone == null || current.maxTimestamp() >= this.tombstone.maxTimestamp()) {
                    this.tombstone = (RangeTombstone)current;
                }
            } else {
                Column column = (Column)current;
                this.container.addColumn(column);
                if (LazilyCompactedRow.this.indexer == SecondaryIndexManager.nullUpdater) {
                    return;
                }
                if (!column.isMarkedForDelete(System.currentTimeMillis()) && !this.container.getColumn(column.name()).equals(column)) {
                    LazilyCompactedRow.this.indexer.remove(column);
                }
            }
        }

        @Override
        protected OnDiskAtom getReduced() {
            if (this.tombstone != null) {
                RangeTombstone t = this.tombstone;
                this.tombstone = null;
                if (((DeletionTime)t.data).isGcAble(((LazilyCompactedRow)LazilyCompactedRow.this).controller.gcBefore)) {
                    return null;
                }
                return t;
            }
            this.container.delete(LazilyCompactedRow.this.maxRowTombstone);
            ColumnFamily purged = PrecompactedRow.removeDeleted(LazilyCompactedRow.this.key, LazilyCompactedRow.this.shouldPurge, LazilyCompactedRow.this.controller, this.container);
            if (purged == null || !purged.iterator().hasNext()) {
                this.container.clear();
                return null;
            }
            Column reduced = purged.iterator().next();
            this.container.clear();
            if (LazilyCompactedRow.this.indexBuilder.tombstoneTracker().isDeleted(reduced)) {
                LazilyCompactedRow.this.indexer.remove(reduced);
                return null;
            }
            ++this.columns;
            this.minTimestampSeen = Math.min(this.minTimestampSeen, reduced.minTimestamp());
            this.maxTimestampSeen = Math.max(this.maxTimestampSeen, reduced.maxTimestamp());
            this.maxLocalDeletionTimeSeen = Math.max(this.maxLocalDeletionTimeSeen, reduced.getLocalDeletionTime());
            this.minColumnNameSeen = ColumnNameHelper.minComponents(this.minColumnNameSeen, reduced.name(), ((LazilyCompactedRow)LazilyCompactedRow.this).controller.cfs.metadata.comparator);
            this.maxColumnNameSeen = ColumnNameHelper.maxComponents(this.maxColumnNameSeen, reduced.name(), ((LazilyCompactedRow)LazilyCompactedRow.this).controller.cfs.metadata.comparator);
            int deletionTime = reduced.getLocalDeletionTime();
            if (deletionTime < Integer.MAX_VALUE) {
                this.tombstones.update(deletionTime);
            }
            return reduced;
        }
    }
}

