/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;

public class CompositesIndexOnClusteringKey
extends CompositesIndex {
    public static CompositeType buildIndexComparator(CFMetaData baseMetadata, ColumnDefinition columnDef) {
        int i;
        int ckCount = baseMetadata.clusteringKeyColumns().size();
        ArrayList types = new ArrayList(ckCount);
        List<AbstractType<?>> ckTypes = baseMetadata.comparator.getComponents();
        types.add(SecondaryIndex.keyComparator);
        for (i = 0; i < columnDef.componentIndex; ++i) {
            types.add(ckTypes.get(i));
        }
        for (i = columnDef.componentIndex + 1; i < ckCount; ++i) {
            types.add(ckTypes.get(i));
        }
        return CompositeType.getInstance(types);
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Column column) {
        CompositeType baseComparator = (CompositeType)this.baseCfs.getComparator();
        ByteBuffer[] components = baseComparator.split(column.name());
        return components[this.columnDef.componentIndex];
    }

    @Override
    protected ColumnNameBuilder makeIndexColumnNameBuilder(ByteBuffer rowKey, ByteBuffer columnName) {
        int i;
        int ckCount = this.baseCfs.metadata.clusteringKeyColumns().size();
        CompositeType baseComparator = (CompositeType)this.baseCfs.getComparator();
        ByteBuffer[] components = baseComparator.split(columnName);
        CompositeType.Builder builder = this.getIndexComparator().builder();
        builder.add(rowKey);
        for (i = 0; i < Math.min(components.length, this.columnDef.componentIndex); ++i) {
            builder.add(components[i]);
        }
        for (i = this.columnDef.componentIndex + 1; i < Math.min(components.length, ckCount); ++i) {
            builder.add(components[i]);
        }
        return builder;
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Column indexEntry) {
        int i;
        int ckCount = this.baseCfs.metadata.clusteringKeyColumns().size();
        ByteBuffer[] components = this.getIndexComparator().split(indexEntry.name());
        CompositeType.Builder builder = this.getBaseComparator().builder();
        for (i = 0; i < this.columnDef.componentIndex; ++i) {
            builder.add(components[i + 1]);
        }
        builder.add(indexedValue.key);
        for (i = this.columnDef.componentIndex + 1; i < ckCount; ++i) {
            builder.add(components[i]);
        }
        return new CompositesIndex.IndexedEntry(indexedValue, indexEntry.name(), indexEntry.timestamp(), components[0], builder);
    }

    @Override
    public boolean indexes(ByteBuffer name) {
        return true;
    }

    @Override
    public boolean isStale(CompositesIndex.IndexedEntry entry, ColumnFamily data, long now) {
        return data.hasOnlyTombstones(now);
    }
}

