/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.marshal.CompositeType;

public class CompositesIndexOnPartitionKey
extends CompositesIndex {
    public static CompositeType buildIndexComparator(CFMetaData baseMetadata, ColumnDefinition columnDef) {
        int ckCount = baseMetadata.clusteringKeyColumns().size();
        ArrayList types = new ArrayList(ckCount + 1);
        types.add(SecondaryIndex.keyComparator);
        types.addAll(baseMetadata.comparator.getComponents());
        return CompositeType.getInstance(types);
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Column column) {
        CompositeType keyComparator = (CompositeType)this.baseCfs.metadata.getKeyValidator();
        ByteBuffer[] components = keyComparator.split(rowKey);
        return components[this.columnDef.componentIndex];
    }

    @Override
    protected ColumnNameBuilder makeIndexColumnNameBuilder(ByteBuffer rowKey, ByteBuffer columnName) {
        int ckCount = this.baseCfs.metadata.clusteringKeyColumns().size();
        CompositeType baseComparator = (CompositeType)this.baseCfs.getComparator();
        ByteBuffer[] components = baseComparator.split(columnName);
        CompositeType.Builder builder = this.getIndexComparator().builder();
        builder.add(rowKey);
        for (int i = 0; i < ckCount; ++i) {
            builder.add(components[i]);
        }
        return builder;
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Column indexEntry) {
        int ckCount = this.baseCfs.metadata.clusteringKeyColumns().size();
        ByteBuffer[] components = this.getIndexComparator().split(indexEntry.name());
        CompositeType.Builder builder = this.getBaseComparator().builder();
        for (int i = 0; i < ckCount; ++i) {
            builder.add(components[i + 1]);
        }
        return new CompositesIndex.IndexedEntry(indexedValue, indexEntry.name(), indexEntry.timestamp(), components[0], builder);
    }

    @Override
    public boolean indexes(ByteBuffer name) {
        return true;
    }

    @Override
    public boolean isStale(CompositesIndex.IndexedEntry entry, ColumnFamily data, long now) {
        return data.hasOnlyTombstones(now);
    }
}

