/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class IntegerSerializer
implements TypeSerializer<BigInteger> {
    public static final IntegerSerializer instance = new IntegerSerializer();

    @Override
    public BigInteger deserialize(ByteBuffer bytes) {
        return new BigInteger(ByteBufferUtil.getArray(bytes));
    }

    @Override
    public ByteBuffer serialize(BigInteger value) {
        return ByteBuffer.wrap(value.toByteArray());
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
    }

    @Override
    public String toString(BigInteger value) {
        return value.toString(10);
    }

    @Override
    public Class<BigInteger> getType() {
        return BigInteger.class;
    }
}

