/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PrepareResponse;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosState {
    private static final Logger logger = LoggerFactory.getLogger(PaxosState.class);
    private static final Object[] locks = new Object[1024];
    private final Commit promised;
    private final Commit accepted;
    private final Commit mostRecentCommit;

    private static Object lockFor(ByteBuffer key) {
        return locks[(Integer.MAX_VALUE & key.hashCode()) % locks.length];
    }

    public PaxosState(ByteBuffer key, CFMetaData metadata) {
        this(Commit.emptyCommit(key, metadata), Commit.emptyCommit(key, metadata), Commit.emptyCommit(key, metadata));
    }

    public PaxosState(Commit promised, Commit accepted, Commit mostRecentCommit) {
        assert (promised.key == accepted.key && accepted.key == mostRecentCommit.key);
        assert (promised.update.metadata() == accepted.update.metadata() && accepted.update.metadata() == mostRecentCommit.update.metadata());
        this.promised = promised;
        this.accepted = accepted;
        this.mostRecentCommit = mostRecentCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrepareResponse prepare(Commit toPrepare) {
        Object object = PaxosState.lockFor(toPrepare.key);
        synchronized (object) {
            PaxosState state = SystemKeyspace.loadPaxosState(toPrepare.key, toPrepare.update.metadata());
            if (toPrepare.isAfter(state.promised)) {
                Tracing.trace("Promising ballot {}", toPrepare.ballot);
                SystemKeyspace.savePaxosPromise(toPrepare);
                return new PrepareResponse(true, state.accepted, state.mostRecentCommit);
            }
            Tracing.trace("Promise rejected; {} is not sufficiently newer than {}", toPrepare, state.promised);
            return new PrepareResponse(false, state.promised, state.mostRecentCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean propose(Commit proposal) {
        Object object = PaxosState.lockFor(proposal.key);
        synchronized (object) {
            PaxosState state = SystemKeyspace.loadPaxosState(proposal.key, proposal.update.metadata());
            if (proposal.hasBallot(state.promised.ballot) || proposal.isAfter(state.promised)) {
                Tracing.trace("Accepting proposal {}", proposal);
                SystemKeyspace.savePaxosProposal(proposal);
                return true;
            }
            Tracing.trace("Rejecting proposal for {} because inProgress is now {}", proposal, state.promised);
            return false;
        }
    }

    public static void commit(Commit proposal) {
        Tracing.trace("Committing proposal {}", proposal);
        RowMutation rm = proposal.makeMutation();
        Keyspace.open(rm.getKeyspaceName()).apply(rm, true);
        SystemKeyspace.savePaxosCommit(proposal);
    }

    static {
        for (int i = 0; i < locks.length; ++i) {
            PaxosState.locks[i] = new Object();
        }
    }
}

