/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.KerberosMessageType;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptedDataDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.TicketDecoder;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.server.kerberos.shared.messages.value.ApOptions;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERBitString;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class ApplicationRequestDecoder {
    public ApplicationRequest decode(byte[] encodedAuthHeader) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedAuthHeader);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        DERSequence apreq = (DERSequence)app.getObject();
        return this.decodeApplicationRequestSequence(apreq);
    }

    private ApplicationRequest decodeApplicationRequestSequence(DERSequence sequence) throws IOException {
        ApplicationRequest authHeader = new ApplicationRequest();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    authHeader.setProtocolVersionNumber(tag0.intValue());
                    break;
                }
                case 1: {
                    DERInteger tag1 = (DERInteger)derObject;
                    authHeader.setMessageType(KerberosMessageType.getTypeByOrdinal(tag1.intValue()));
                    break;
                }
                case 2: {
                    DERBitString apOptions = (DERBitString)derObject;
                    authHeader.setApOptions(new ApOptions(apOptions.getOctets()));
                    break;
                }
                case 3: {
                    DERApplicationSpecific tag3 = (DERApplicationSpecific)derObject;
                    authHeader.setTicket(TicketDecoder.decode(tag3));
                    break;
                }
                case 4: {
                    DERSequence tag4 = (DERSequence)derObject;
                    authHeader.setEncPart(EncryptedDataDecoder.decode(tag4));
                }
            }
        }
        return authHeader;
    }
}

