/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;

public class StackTrace {
    private final StackTraceElement[] stackTraceElements;

    public StackTrace() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        this.stackTraceElements = Arrays.copyOfRange(stack, 1, stack.length - 1);
    }

    public void write(Writer writer, int indent) {
        char[] indentation = new char[indent];
        Arrays.fill(indentation, ' ');
        try {
            for (StackTraceElement ste : this.stackTraceElements) {
                writer.write(indentation);
                writer.write(ste.getClassName());
                writer.write(46);
                writer.write(ste.getMethodName());
                writer.write(58);
                writer.write(Integer.toString(ste.getLineNumber()));
                writer.write(10);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("couldn't write", e);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.write(sw, 0);
        return sw.toString();
    }
}

