/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.util;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.drill.common.exceptions.LogicalPlanParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicBean {
    static final Logger logger = LoggerFactory.getLogger(AbstractDynamicBean.class);
    private static volatile ObjectMapper MAPPER;
    private ObjectNode objectNode = new ObjectNode(null);

    @JsonAnySetter
    public void _anySetter(String name, JsonNode value) {
        this.objectNode.put(name, value);
    }

    @JsonAnyGetter
    public Map<String, JsonNode> _anyGetter() {
        HashMap<String, JsonNode> unknowns = new HashMap<String, JsonNode>();
        Iterator i = this.objectNode.fields();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            unknowns.put((String)e.getKey(), (JsonNode)e.getValue());
        }
        return unknowns;
    }

    public <T> T getWith(Class<T> c) {
        try {
            return (T)AbstractDynamicBean.getMapper().treeToValue((TreeNode)this.objectNode, c);
        }
        catch (JsonProcessingException e) {
            throw new LogicalPlanParsingException(String.format("Failure while trying to convert late bound json type to type of %s.", c.getCanonicalName()), e);
        }
    }

    private static synchronized ObjectMapper getMapper() {
        if (MAPPER == null) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            MAPPER = mapper;
        }
        return MAPPER;
    }
}

