/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.util;

import com.google.common.base.Function;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public enum Hook {
    LOGICAL_PLAN;

    private final List<Function<Object, Object>> handlers = new CopyOnWriteArrayList<Function<Object, Object>>();

    public Closeable add(final Function handler) {
        this.handlers.add((Function<Object, Object>)handler);
        return new Closeable(){

            @Override
            public void close() {
                Hook.this.remove(handler);
            }
        };
    }

    private boolean remove(Function handler) {
        return this.handlers.remove(handler);
    }

    public void run(Object arg) {
        for (Function<Object, Object> handler : this.handlers) {
            handler.apply(arg);
        }
    }

    public static interface Closeable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

