/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.util;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathScanner {
    static final Logger logger = LoggerFactory.getLogger(PathScanner.class);
    private static final SubTypesScanner subTypeScanner = new SubTypesScanner();
    private static final TypeAnnotationsScanner annotationsScanner = new TypeAnnotationsScanner();
    private static final ResourcesScanner resourcesScanner = new ResourcesScanner();
    private static final Object SYNC = new Object();
    static volatile Reflections REFLECTIONS = null;

    public static <A extends Annotation, T> Map<A, Class<? extends T>> scanForAnnotatedImplementations(Class<A> annotationClass, Class<T> baseClass, List<String> scanPackages) {
        Set<Class<T>> providerClasses = PathScanner.scanForImplementations(baseClass, scanPackages);
        HashMap<A, Class> map = new HashMap<A, Class>();
        for (Class clazz : providerClasses) {
            A annotation = clazz.getAnnotation(annotationClass);
            if (annotation == null) continue;
            map.put(annotation, clazz);
        }
        return map;
    }

    private static Reflections getReflections() {
        if (REFLECTIONS == null) {
            REFLECTIONS = new Reflections((Configuration)new ConfigurationBuilder().setUrls(PathScanner.getMarkedPaths()).setScanners(new Scanner[]{subTypeScanner, annotationsScanner, resourcesScanner}));
        }
        return REFLECTIONS;
    }

    public static <T> Class<?>[] scanForImplementationsArr(Class<T> baseClass, List<String> scanPackages) {
        Set<Class<Class>> imps = PathScanner.scanForImplementations(baseClass, scanPackages);
        Class[] arr = imps.toArray(new Class[imps.size()]);
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Set<Class<? extends T>> scanForImplementations(Class<T> baseClass, List<String> scanPackages) {
        Stopwatch w = new Stopwatch().start();
        try {
            Object object = SYNC;
            synchronized (object) {
                Set classes = PathScanner.getReflections().getSubTypesOf(baseClass);
                Iterator i = classes.iterator();
                while (i.hasNext()) {
                    Class c = (Class)i.next();
                    assert (baseClass.isAssignableFrom(c));
                    if (!Modifier.isAbstract(c.getModifiers())) continue;
                    i.remove();
                }
                Set set = classes;
                return set;
            }
        }
        finally {
            logger.debug("Classpath scanning took {}ms", (Object)w.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private static Collection<URL> getMarkedPaths() {
        Set<URL> urls = PathScanner.forResource("drill-module.conf", true, new ClassLoader[0]);
        return urls;
    }

    public static Collection<URL> getConfigURLs() {
        return PathScanner.forResource("drill-module.conf", false, new ClassLoader[0]);
    }

    public static Set<URL> forResource(String name, boolean stripName, ClassLoader ... classLoaders) {
        HashSet result = Sets.newHashSet();
        ClassLoader[] loaders = ClasspathHelper.classLoaders((ClassLoader[])classLoaders);
        String resourceName = name;
        for (ClassLoader classLoader : loaders) {
            try {
                Enumeration<URL> urls = classLoader.getResources(resourceName);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    int index = url.toExternalForm().lastIndexOf(resourceName);
                    if (index != -1 && stripName) {
                        result.add(new URL(url.toExternalForm().substring(0, index)));
                        continue;
                    }
                    result.add(url);
                }
            }
            catch (IOException e) {
                if (Reflections.log == null) continue;
                Reflections.log.error("error getting resources for package " + name, (Throwable)e);
            }
        }
        return result;
    }
}

