
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
// Source code generated using FreeMarker template CountAggregateFunctions.java

package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;

@SuppressWarnings("unused")

public class CountFunctions {
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class BitCountFunction implements DrillAggFunc {

    @Param BitHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableBitCountFunction implements DrillAggFunc {

    @Param NullableBitHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class IntCountFunction implements DrillAggFunc {

    @Param IntHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableIntCountFunction implements DrillAggFunc {

    @Param NullableIntHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class BigIntCountFunction implements DrillAggFunc {

    @Param BigIntHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableBigIntCountFunction implements DrillAggFunc {

    @Param NullableBigIntHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class Float4CountFunction implements DrillAggFunc {

    @Param Float4Holder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableFloat4CountFunction implements DrillAggFunc {

    @Param NullableFloat4Holder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class Float8CountFunction implements DrillAggFunc {

    @Param Float8Holder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableFloat8CountFunction implements DrillAggFunc {

    @Param NullableFloat8Holder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class DateCountFunction implements DrillAggFunc {

    @Param DateHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableDateCountFunction implements DrillAggFunc {

    @Param NullableDateHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class TimeStampCountFunction implements DrillAggFunc {

    @Param TimeStampHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableTimeStampCountFunction implements DrillAggFunc {

    @Param NullableTimeStampHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class TimeCountFunction implements DrillAggFunc {

    @Param TimeHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableTimeCountFunction implements DrillAggFunc {

    @Param NullableTimeHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class IntervalDayCountFunction implements DrillAggFunc {

    @Param IntervalDayHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableIntervalDayCountFunction implements DrillAggFunc {

    @Param NullableIntervalDayHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class IntervalYearCountFunction implements DrillAggFunc {

    @Param IntervalYearHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableIntervalYearCountFunction implements DrillAggFunc {

    @Param NullableIntervalYearHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class IntervalCountFunction implements DrillAggFunc {

    @Param IntervalHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableIntervalCountFunction implements DrillAggFunc {

    @Param NullableIntervalHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class VarCharCountFunction implements DrillAggFunc {

    @Param VarCharHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableVarCharCountFunction implements DrillAggFunc {

    @Param NullableVarCharHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class VarBinaryCountFunction implements DrillAggFunc {

    @Param VarBinaryHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableVarBinaryCountFunction implements DrillAggFunc {

    @Param NullableVarBinaryHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class Decimal9CountFunction implements DrillAggFunc {

    @Param Decimal9Holder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableDecimal9CountFunction implements DrillAggFunc {

    @Param NullableDecimal9Holder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class Decimal18CountFunction implements DrillAggFunc {

    @Param Decimal18Holder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableDecimal18CountFunction implements DrillAggFunc {

    @Param NullableDecimal18Holder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class Decimal28SparseCountFunction implements DrillAggFunc {

    @Param Decimal28SparseHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableDecimal28SparseCountFunction implements DrillAggFunc {

    @Param NullableDecimal28SparseHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class Decimal38SparseCountFunction implements DrillAggFunc {

    @Param Decimal38SparseHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        value.value++;
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
  @FunctionTemplate(name = "count", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)
  public static class NullableDecimal38SparseCountFunction implements DrillAggFunc {

    @Param NullableDecimal38SparseHolder in;
    @Workspace BigIntHolder value;
    @Output BigIntHolder out;

    @Override
    public void setup() {
	    value = new BigIntHolder();
      value.value = 0;
    }

    @Override
    public void add() {
        if (in.isSet == 1) {
          value.value++;
        }
    }

    @Override
    public void output() {
      out.value = value.value;
    }

    @Override
    public void reset() {
      value.value = 0;
    }
  }
}