/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.jaas.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.spi.LoginModule;
import org.apache.felix.jaas.internal.Logger;
import org.apache.felix.jaas.internal.LoginModuleCreator;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;

class BundleLoginModuleCreator
extends BundleTracker
implements LoginModuleCreator {
    private static final String JAAS_MODULE_CLASS = "Jaas-ModuleClass";
    private final Map<String, LoginModuleInfo> loginModuleInfo = new ConcurrentHashMap<String, LoginModuleInfo>();
    private final Logger log;

    public BundleLoginModuleCreator(BundleContext context, Logger log) {
        super(context, 32, null);
        this.log = log;
    }

    @Override
    public LoginModule newInstance(String className) {
        LoginModuleInfo lmInfo = this.loginModuleInfo.get(className);
        if (lmInfo == null) {
            throw new AssertionError((Object)("No bundle exists to create LoginModule from " + className));
        }
        try {
            return lmInfo.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error occurred while creating LoginModule for " + className, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error occurred while creating LoginModule for " + className, e);
        }
    }

    public Map<Bundle, Set<String>> getBundleToLoginModuleMapping() {
        HashMap<Bundle, Set<String>> bundleMap = new HashMap<Bundle, Set<String>>();
        for (LoginModuleInfo e : this.loginModuleInfo.values()) {
            Bundle b = e.getBundle();
            Set classNames = (Set)this.getObject(b);
            if (classNames == null) continue;
            bundleMap.put(b, classNames);
        }
        return bundleMap;
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (this.providesLoginModule(bundle)) {
            return this.registerBundle(bundle);
        }
        return null;
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        Set classNames = (Set)object;
        for (String className : classNames) {
            this.loginModuleInfo.remove(className);
        }
    }

    private boolean providesLoginModule(Bundle bundle) {
        return bundle.getHeaders().get(JAAS_MODULE_CLASS) != null;
    }

    private Set<String> registerBundle(Bundle bundle) {
        Set<String> classNames = BundleLoginModuleCreator.parseHeader((String)bundle.getHeaders().get(JAAS_MODULE_CLASS));
        for (String className : classNames) {
            LoginModuleInfo bi = new LoginModuleInfo(className, bundle, this.log);
            if (bi.isValid()) {
                if (this.loginModuleInfo.containsKey(className)) {
                    LoginModuleInfo existingInfo = this.loginModuleInfo.get(className);
                    String msg = String.format("LoginModule class %s is already registered with Bundle %s. Entry from bundle %s would be ignored", className, existingInfo.getBundle(), bundle);
                    this.log.log(2, msg);
                    continue;
                }
                this.loginModuleInfo.put(className, bi);
                this.log.log(3, "Registering LoginModule class [" + className + "] from Bundle" + bundle);
                continue;
            }
            this.log.log(2, "Could not load LoginModule class " + bi.getClassName() + " from bundle " + bundle);
        }
        return classNames;
    }

    private static Set<String> parseHeader(String header) {
        HashSet<String> values = new HashSet<String>();
        ManifestHeader mh = ManifestHeader.parse(header);
        for (ManifestHeader.Entry e : mh.getEntries()) {
            values.add(e.getValue());
        }
        return values;
    }

    static final class LoginModuleInfo {
        private final String className;
        private final Bundle bundle;
        private final Class<LoginModule> clazz;

        public LoginModuleInfo(String className, Bundle bundle, Logger log) {
            this.className = className;
            this.bundle = bundle;
            Class clazz = null;
            try {
                clazz = bundle.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                log.log(2, "Error loading class [" + className + "] from bundle " + bundle, e);
            }
            this.clazz = clazz;
        }

        public LoginModule newInstance() throws IllegalAccessException, InstantiationException {
            if (this.clazz == null) {
                throw new IllegalStateException("LoginModule class not initialized");
            }
            return this.clazz.newInstance();
        }

        public boolean isValid() {
            return this.clazz != null;
        }

        public String getClassName() {
            return this.className;
        }

        public Bundle getBundle() {
            return this.bundle;
        }
    }
}

