/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.collect.Lists;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.BlockingService;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestProtoBufRpc {
    public static final String ADDRESS = "localhost";
    public static int PORT = 0;
    private InetSocketAddress isa;
    private Configuration conf;
    private RpcServerInterface server;

    @Before
    public void setUp() throws IOException {
        this.conf = HBaseConfiguration.create();
        Logger log = Logger.getLogger((String)"org.apache.hadoop.ipc.HBaseServer");
        log.setLevel(Level.DEBUG);
        log = Logger.getLogger((String)"org.apache.hadoop.ipc.HBaseServer.trace");
        log.setLevel(Level.TRACE);
        PBServerImpl serverImpl = new PBServerImpl();
        BlockingService service = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService(serverImpl);
        this.server = new RpcServer(null, "testrpc", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(service, null)}), new InetSocketAddress(ADDRESS, PORT), this.conf, (RpcScheduler)new FifoRpcScheduler(this.conf, 10));
        this.isa = this.server.getListenerAddress();
        this.server.start();
    }

    @After
    public void tearDown() throws Exception {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProtoBufRpc() throws Exception {
        RpcClient rpcClient = new RpcClient(this.conf, "default-cluster");
        try {
            BlockingRpcChannel channel = rpcClient.createBlockingRpcChannel(ServerName.valueOf((String)this.isa.getHostName(), (int)this.isa.getPort(), (long)System.currentTimeMillis()), User.getCurrent(), 0);
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestRpcServiceProtos.TestProtobufRpcProto.newBlockingStub(channel);
            TestProtos.EmptyRequestProto emptyRequest = TestProtos.EmptyRequestProto.newBuilder().build();
            stub.ping(null, emptyRequest);
            TestProtos.EchoRequestProto echoRequest = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
            TestProtos.EchoResponseProto echoResponse = stub.echo(null, echoRequest);
            Assert.assertEquals((Object)echoResponse.getMessage(), (Object)"hello");
            try {
                stub.error(null, emptyRequest);
                Assert.fail((String)"Expected exception is not thrown");
            }
            catch (ServiceException e) {
                // empty catch block
            }
        }
        finally {
            rpcClient.stop();
        }
    }

    static class PBServerImpl
    implements TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface {
        PBServerImpl() {
        }

        @Override
        public TestProtos.EmptyResponseProto ping(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }

        @Override
        public TestProtos.EchoResponseProto echo(RpcController unused, TestProtos.EchoRequestProto request) throws ServiceException {
            return TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
        }

        @Override
        public TestProtos.EmptyResponseProto error(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            throw new ServiceException("error", (Throwable)new IOException("error"));
        }
    }
}

