/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.master.ActiveMasterManager;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestActiveMasterManager {
    private static final Log LOG = LogFactory.getLog(TestActiveMasterManager.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testRestartMaster() throws IOException, KeeperException {
        ZooKeeperWatcher zk = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testActiveMasterManagerFromZK", null, true);
        try {
            ZKUtil.deleteNode((ZooKeeperWatcher)zk, (String)zk.getMasterAddressZNode());
            ZKUtil.deleteNode((ZooKeeperWatcher)zk, (String)zk.clusterStateZNode);
        }
        catch (KeeperException.NoNodeException nne) {
            // empty catch block
        }
        ServerName master = ServerName.valueOf((String)"localhost", (int)1, (long)System.currentTimeMillis());
        DummyMaster dummyMaster = new DummyMaster(zk, master);
        ClusterStatusTracker clusterStatusTracker = dummyMaster.getClusterStatusTracker();
        ActiveMasterManager activeMasterManager = dummyMaster.getActiveMasterManager();
        Assert.assertFalse((boolean)activeMasterManager.clusterHasActiveMaster.get());
        MonitoredTask status = (MonitoredTask)Mockito.mock(MonitoredTask.class);
        clusterStatusTracker.setClusterUp();
        activeMasterManager.blockUntilBecomingActiveMaster(status);
        Assert.assertTrue((boolean)activeMasterManager.clusterHasActiveMaster.get());
        this.assertMaster(zk, master);
        DummyMaster secondDummyMaster = new DummyMaster(zk, master);
        ActiveMasterManager secondActiveMasterManager = secondDummyMaster.getActiveMasterManager();
        Assert.assertFalse((boolean)secondActiveMasterManager.clusterHasActiveMaster.get());
        activeMasterManager.blockUntilBecomingActiveMaster(status);
        Assert.assertTrue((boolean)activeMasterManager.clusterHasActiveMaster.get());
        this.assertMaster(zk, master);
    }

    @Test
    public void testActiveMasterManagerFromZK() throws Exception {
        int sleeps;
        ZooKeeperWatcher zk = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testActiveMasterManagerFromZK", null, true);
        try {
            ZKUtil.deleteNode((ZooKeeperWatcher)zk, (String)zk.getMasterAddressZNode());
            ZKUtil.deleteNode((ZooKeeperWatcher)zk, (String)zk.clusterStateZNode);
        }
        catch (KeeperException.NoNodeException nne) {
            // empty catch block
        }
        ServerName firstMasterAddress = ServerName.valueOf((String)"localhost", (int)1, (long)System.currentTimeMillis());
        ServerName secondMasterAddress = ServerName.valueOf((String)"localhost", (int)2, (long)System.currentTimeMillis());
        DummyMaster ms1 = new DummyMaster(zk, firstMasterAddress);
        ActiveMasterManager activeMasterManager = ms1.getActiveMasterManager();
        Assert.assertFalse((boolean)activeMasterManager.clusterHasActiveMaster.get());
        ClusterStatusTracker clusterStatusTracker = ms1.getClusterStatusTracker();
        clusterStatusTracker.setClusterUp();
        activeMasterManager.blockUntilBecomingActiveMaster((MonitoredTask)Mockito.mock(MonitoredTask.class));
        Assert.assertTrue((boolean)activeMasterManager.clusterHasActiveMaster.get());
        this.assertMaster(zk, firstMasterAddress);
        WaitToBeMasterThread t = new WaitToBeMasterThread(zk, secondMasterAddress);
        t.start();
        for (sleeps = 0; !t.manager.clusterHasActiveMaster.get() && sleeps < 100; ++sleeps) {
            Thread.sleep(10L);
        }
        Assert.assertTrue((boolean)activeMasterManager.clusterHasActiveMaster.get());
        Assert.assertTrue((boolean)t.manager.clusterHasActiveMaster.get());
        Assert.assertFalse((boolean)t.isActiveMaster);
        ms1.stop("stopping first server");
        NodeDeletionListener listener = new NodeDeletionListener(zk, zk.getMasterAddressZNode());
        zk.registerListener((ZooKeeperListener)listener);
        LOG.info((Object)"Deleting master node");
        ZKUtil.deleteNode((ZooKeeperWatcher)zk, (String)zk.getMasterAddressZNode());
        LOG.info((Object)"Waiting for active master manager to be notified");
        listener.waitForDeletion();
        LOG.info((Object)"Master node deleted");
        for (sleeps = 0; !t.isActiveMaster && sleeps < 100; ++sleeps) {
            Thread.sleep(10L);
        }
        LOG.debug((Object)("Slept " + sleeps + " times"));
        Assert.assertTrue((boolean)t.manager.clusterHasActiveMaster.get());
        Assert.assertTrue((boolean)t.isActiveMaster);
        LOG.info((Object)"Deleting master node");
        ZKUtil.deleteNode((ZooKeeperWatcher)zk, (String)zk.getMasterAddressZNode());
    }

    private void assertMaster(ZooKeeperWatcher zk, ServerName expectedAddress) throws KeeperException, IOException {
        ServerName readAddress = MasterAddressTracker.getMasterAddress((ZooKeeperWatcher)zk);
        Assert.assertNotNull((Object)readAddress);
        Assert.assertTrue((boolean)expectedAddress.equals((Object)readAddress));
    }

    public static class DummyMaster
    implements Server {
        private volatile boolean stopped;
        private ClusterStatusTracker clusterStatusTracker;
        private ActiveMasterManager activeMasterManager;

        public DummyMaster(ZooKeeperWatcher zk, ServerName master) {
            this.clusterStatusTracker = new ClusterStatusTracker(zk, (Abortable)this);
            this.clusterStatusTracker.start();
            this.activeMasterManager = new ActiveMasterManager(zk, master, (Server)this);
            zk.registerListener((ZooKeeperListener)this.activeMasterManager);
        }

        public void abort(String msg, Throwable t) {
        }

        public boolean isAborted() {
            return false;
        }

        public Configuration getConfiguration() {
            return null;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return null;
        }

        public ServerName getServerName() {
            return null;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public void stop(String why) {
            this.stopped = true;
        }

        public CatalogTracker getCatalogTracker() {
            return null;
        }

        public ClusterStatusTracker getClusterStatusTracker() {
            return this.clusterStatusTracker;
        }

        public ActiveMasterManager getActiveMasterManager() {
            return this.activeMasterManager;
        }
    }

    public static class NodeDeletionListener
    extends ZooKeeperListener {
        private static final Log LOG = LogFactory.getLog(NodeDeletionListener.class);
        private Semaphore lock = new Semaphore(0);
        private String node;

        public NodeDeletionListener(ZooKeeperWatcher watcher, String node) {
            super(watcher);
            this.node = node;
        }

        public void nodeDeleted(String path) {
            if (path.equals(this.node)) {
                LOG.debug((Object)("nodeDeleted(" + path + ")"));
                this.lock.release();
            }
        }

        public void waitForDeletion() throws InterruptedException {
            this.lock.acquire();
        }
    }

    public static class WaitToBeMasterThread
    extends Thread {
        ActiveMasterManager manager;
        DummyMaster dummyMaster;
        boolean isActiveMaster;

        public WaitToBeMasterThread(ZooKeeperWatcher zk, ServerName address) {
            this.dummyMaster = new DummyMaster(zk, address);
            this.manager = this.dummyMaster.getActiveMasterManager();
            this.isActiveMaster = false;
        }

        @Override
        public void run() {
            this.manager.blockUntilBecomingActiveMaster((MonitoredTask)Mockito.mock(MonitoredTask.class));
            LOG.info((Object)"Second master has become the active master!");
            this.isActiveMaster = true;
        }
    }
}

