/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionSplitter {
    private static final Log LOG = LogFactory.getLog(TestRegionSplitter.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final String CF_NAME = "SPLIT_TEST_CF";
    private static final byte xFF = -1;

    @BeforeClass
    public static void setup() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCreatePresplitTableHex() throws Exception {
        ArrayList<byte[]> expectedBounds = new ArrayList<byte[]>();
        expectedBounds.add(ArrayUtils.EMPTY_BYTE_ARRAY);
        expectedBounds.add("10000000".getBytes());
        expectedBounds.add("20000000".getBytes());
        expectedBounds.add("30000000".getBytes());
        expectedBounds.add("40000000".getBytes());
        expectedBounds.add("50000000".getBytes());
        expectedBounds.add("60000000".getBytes());
        expectedBounds.add("70000000".getBytes());
        expectedBounds.add("80000000".getBytes());
        expectedBounds.add("90000000".getBytes());
        expectedBounds.add("a0000000".getBytes());
        expectedBounds.add("b0000000".getBytes());
        expectedBounds.add("c0000000".getBytes());
        expectedBounds.add("d0000000".getBytes());
        expectedBounds.add("e0000000".getBytes());
        expectedBounds.add("f0000000".getBytes());
        expectedBounds.add(ArrayUtils.EMPTY_BYTE_ARRAY);
        this.preSplitTableAndVerify(expectedBounds, RegionSplitter.HexStringSplit.class.getSimpleName(), "NewHexPresplitTable");
    }

    @Test
    public void testCreatePresplitTableUniform() throws Exception {
        ArrayList<byte[]> expectedBounds = new ArrayList<byte[]>();
        expectedBounds.add(ArrayUtils.EMPTY_BYTE_ARRAY);
        expectedBounds.add(new byte[]{16, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{32, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{48, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{64, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{80, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{96, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{112, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-128, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-112, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-96, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-80, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-64, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-48, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-32, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(new byte[]{-16, 0, 0, 0, 0, 0, 0, 0});
        expectedBounds.add(ArrayUtils.EMPTY_BYTE_ARRAY);
        this.preSplitTableAndVerify(expectedBounds, RegionSplitter.UniformSplit.class.getSimpleName(), "NewUniformPresplitTable");
    }

    @Test
    public void unitTestHexStringSplit() {
        RegionSplitter.HexStringSplit splitter = new RegionSplitter.HexStringSplit();
        byte[][] twoRegionsSplits = splitter.split(2);
        Assert.assertEquals((long)1L, (long)twoRegionsSplits.length);
        Assert.assertArrayEquals((byte[])twoRegionsSplits[0], (byte[])"80000000".getBytes());
        byte[][] threeRegionsSplits = splitter.split(3);
        Assert.assertEquals((long)2L, (long)threeRegionsSplits.length);
        byte[] expectedSplit0 = "55555555".getBytes();
        Assert.assertArrayEquals((byte[])expectedSplit0, (byte[])threeRegionsSplits[0]);
        byte[] expectedSplit1 = "aaaaaaaa".getBytes();
        Assert.assertArrayEquals((byte[])expectedSplit1, (byte[])threeRegionsSplits[1]);
        byte[] splitPoint = splitter.split("10000000".getBytes(), "30000000".getBytes());
        Assert.assertArrayEquals((byte[])"20000000".getBytes(), (byte[])splitPoint);
        byte[] lastRow = "ffffffff".getBytes();
        Assert.assertArrayEquals((byte[])lastRow, (byte[])splitter.lastRow());
        byte[] firstRow = "00000000".getBytes();
        Assert.assertArrayEquals((byte[])firstRow, (byte[])splitter.firstRow());
        splitPoint = splitter.split(firstRow, "20000000".getBytes());
        Assert.assertArrayEquals((byte[])splitPoint, (byte[])"10000000".getBytes());
        splitPoint = splitter.split("dfffffff".getBytes(), lastRow);
        Assert.assertArrayEquals((byte[])splitPoint, (byte[])"efffffff".getBytes());
    }

    @Test
    public void unitTestUniformSplit() {
        RegionSplitter.UniformSplit splitter = new RegionSplitter.UniformSplit();
        try {
            splitter.split(1);
            throw new AssertionError((Object)"Splitting into <2 regions should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            byte[][] twoRegionsSplits = splitter.split(2);
            Assert.assertEquals((long)1L, (long)twoRegionsSplits.length);
            Assert.assertArrayEquals((byte[])twoRegionsSplits[0], (byte[])new byte[]{-128, 0, 0, 0, 0, 0, 0, 0});
            byte[][] threeRegionsSplits = splitter.split(3);
            Assert.assertEquals((long)2L, (long)threeRegionsSplits.length);
            byte[] expectedSplit0 = new byte[]{85, 85, 85, 85, 85, 85, 85, 85};
            Assert.assertArrayEquals((byte[])expectedSplit0, (byte[])threeRegionsSplits[0]);
            byte[] expectedSplit1 = new byte[]{-86, -86, -86, -86, -86, -86, -86, -86};
            Assert.assertArrayEquals((byte[])expectedSplit1, (byte[])threeRegionsSplits[1]);
            byte[] splitPoint = splitter.split(new byte[]{16}, new byte[]{48});
            Assert.assertArrayEquals((byte[])new byte[]{32}, (byte[])splitPoint);
            byte[] lastRow = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
            Assert.assertArrayEquals((byte[])lastRow, (byte[])splitter.lastRow());
            byte[] firstRow = ArrayUtils.EMPTY_BYTE_ARRAY;
            Assert.assertArrayEquals((byte[])firstRow, (byte[])splitter.firstRow());
            splitPoint = splitter.split(firstRow, new byte[]{32});
            Assert.assertArrayEquals((byte[])splitPoint, (byte[])new byte[]{16});
            splitPoint = splitter.split(new byte[]{-33, -1, -1, -1, -1, -1, -1, -1}, lastRow);
            Assert.assertArrayEquals((byte[])splitPoint, (byte[])new byte[]{-17, -1, -1, -1, -1, -1, -1, -1});
            return;
        }
    }

    @Test
    public void testUserInput() {
        RegionSplitter.HexStringSplit algo = new RegionSplitter.HexStringSplit();
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "00", "AA"));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "AA", "00"));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "AA", "AA"));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "0", "2", 3));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "0", "A", 11));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "0", "A", 12));
        algo = new RegionSplitter.UniformSplit();
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "\\x00", "\\xAA"));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "\\xAA", "\\x00"));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "\\xAA", "\\xAA"));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "\\x00", "\\x02", 3));
        Assert.assertFalse((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "\\x00", "\\x0A", 11));
        Assert.assertTrue((boolean)this.splitFailsPrecondition((RegionSplitter.SplitAlgorithm)algo, "\\x00", "\\x0A", 12));
    }

    private boolean splitFailsPrecondition(RegionSplitter.SplitAlgorithm algo) {
        return this.splitFailsPrecondition(algo, 100);
    }

    private boolean splitFailsPrecondition(RegionSplitter.SplitAlgorithm algo, String firstRow, String lastRow) {
        return this.splitFailsPrecondition(algo, firstRow, lastRow, 100);
    }

    private boolean splitFailsPrecondition(RegionSplitter.SplitAlgorithm algo, String firstRow, String lastRow, int numRegions) {
        algo.setFirstRow(firstRow);
        algo.setLastRow(lastRow);
        return this.splitFailsPrecondition(algo, numRegions);
    }

    private boolean splitFailsPrecondition(RegionSplitter.SplitAlgorithm algo, int numRegions) {
        try {
            byte[][] s = algo.split(numRegions);
            LOG.debug((Object)("split algo = " + algo));
            if (s != null) {
                StringBuilder sb = new StringBuilder();
                for (byte[] b : s) {
                    sb.append(Bytes.toStringBinary((byte[])b) + "  ");
                }
                LOG.debug((Object)sb.toString());
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        catch (IllegalStateException e) {
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            return true;
        }
    }

    private void preSplitTableAndVerify(List<byte[]> expectedBounds, String splitClass, String tableName) throws Exception {
        int numRegions = expectedBounds.size() - 1;
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("split.count", numRegions);
        RegionSplitter.SplitAlgorithm splitAlgo = RegionSplitter.newSplitAlgoInstance((Configuration)conf, (String)splitClass);
        RegionSplitter.createPresplitTable((String)tableName, (RegionSplitter.SplitAlgorithm)splitAlgo, (String[])new String[]{CF_NAME}, (Configuration)conf);
        this.verifyBounds(expectedBounds, tableName);
    }

    @Test
    public void noopRollingSplit() throws Exception {
        ArrayList<byte[]> expectedBounds = new ArrayList<byte[]>();
        expectedBounds.add(ArrayUtils.EMPTY_BYTE_ARRAY);
        this.rollingSplitAndVerify(TestRegionSplitter.class.getSimpleName(), "UniformSplit", expectedBounds);
    }

    private void rollingSplitAndVerify(String tableName, String splitClass, List<byte[]> expectedBounds) throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("split.outstanding", 5);
        RegionSplitter.SplitAlgorithm splitAlgo = RegionSplitter.newSplitAlgoInstance((Configuration)conf, (String)splitClass);
        RegionSplitter.rollingSplit((String)tableName, (RegionSplitter.SplitAlgorithm)splitAlgo, (Configuration)conf);
        this.verifyBounds(expectedBounds, tableName);
    }

    private void verifyBounds(List<byte[]> expectedBounds, String tableName) throws Exception {
        Configuration conf = UTIL.getConfiguration();
        int numRegions = expectedBounds.size() - 1;
        HTable hTable = new HTable(conf, tableName.getBytes());
        NavigableMap regionInfoMap = hTable.getRegionLocations();
        Assert.assertEquals((long)numRegions, (long)regionInfoMap.size());
        for (Map.Entry entry : regionInfoMap.entrySet()) {
            HRegionInfo regionInfo = (HRegionInfo)entry.getKey();
            byte[] regionStart = regionInfo.getStartKey();
            byte[] regionEnd = regionInfo.getEndKey();
            int startBoundaryIndex = TestRegionSplitter.indexOfBytes(expectedBounds, regionStart);
            Assert.assertNotSame((Object)-1, (Object)startBoundaryIndex);
            byte[] expectedRegionEnd = expectedBounds.get(startBoundaryIndex + 1);
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])regionEnd, (byte[])expectedRegionEnd));
        }
    }

    private static int indexOfBytes(List<byte[]> list, byte[] compareTo) {
        int listIndex = 0;
        for (byte[] elem : list) {
            if (Bytes.BYTES_COMPARATOR.compare(elem, compareTo) == 0) {
                return listIndex;
            }
            ++listIndex;
        }
        return -1;
    }
}

