/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

abstract class AbstractImportXmlTest
extends AbstractJCRTest {
    protected final boolean WORKSPACE = true;
    protected final boolean SESSION = false;
    protected boolean CONTENTHANDLER = true;
    protected boolean STREAM = false;
    protected String target;
    protected String refTarget;
    protected Session session;
    protected Workspace workspace;
    protected NodeTypeManager ntManager;
    protected NamespaceRegistry nsp;
    protected String ntUnstructured;
    protected File file;
    protected String referenced;
    protected String referencing;
    protected Node targetNode;
    protected Node refTargetNode;
    protected String unusedPrefix;
    protected String unusedURI;
    protected final String TEST_PREFIX = "docview";
    protected final String TEST_URI = "http://www.apache.org/jackrabbit/test/namespaceImportTest";
    protected final String XML_NS = "xmlns";
    protected static final String rootElem = "docRoot";
    protected static final String refNodeElem = "refNodeElem";
    protected static final String xmltextElem = "xmltextElem";
    protected static final String childElem = "childElem";
    protected static final String grandChildElem = "grandChildElem";
    protected static final String encodedElemName = "Element_x003C__x003E_Name";
    protected static final String decodedElemName = "Element<>Name";
    protected static final String attributeName = "attribute";
    protected static final String attributeValue = "attrVal";
    protected static final String encodedAttributeName = "Prop_x0020_Name";
    protected static final String decodedAttributeName = "Prop Name";
    protected static final String encodedAttributeValue = "Hello_x0009_&_x0009_GoodBye";
    protected static final String decodedAttributeValue = "Hello\t&\tGoodBye";
    protected String xmltext = "\t Text for docView Export test_x0009_with escaped _x003C_ characters.  ";
    protected boolean respectMixRef = false;
    protected int uuidBehaviour = 0;
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    protected DocumentBuilder dom;

    AbstractImportXmlTest() {
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        try {
            this.dom = this.factory.newDocumentBuilder();
            this.file = File.createTempFile("docViewImportTest", ".xml");
            this.log.print("Tempfile: " + this.file.getAbsolutePath());
            this.session = this.superuser;
            this.workspace = this.session.getWorkspace();
            this.target = this.testRoot + "/target";
            this.targetNode = this.createAncestors(this.target);
            this.refTarget = this.testRoot + "/refTarget";
            this.refTargetNode = this.createAncestors(this.refTarget);
            this.nsp = this.workspace.getNamespaceRegistry();
            this.ntManager = this.workspace.getNodeTypeManager();
            this.unusedPrefix = this.getUnusedPrefix();
            this.unusedURI = this.getUnusedURI();
            this.referenced = this.nodeName1;
            this.referencing = this.nodeName2;
            this.respectMixRef = this.isMixRefRespected();
        }
        catch (Exception ex) {
            if (this.file != null) {
                this.file.delete();
                this.file = null;
            }
            throw ex;
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
        this.session = null;
        this.workspace = null;
        this.ntManager = null;
        this.nsp = null;
        this.targetNode = null;
        this.refTargetNode = null;
        super.tearDown();
    }

    public Document createSimpleDocument() {
        Document doc = this.dom.newDocument();
        Element root = doc.createElementNS(this.unusedURI, this.unusedPrefix + ":" + rootElem);
        root.setAttribute("xmlns:" + this.unusedPrefix, this.unusedURI);
        Element child = doc.createElement(childElem);
        Element xmlElem = doc.createElement(xmltextElem);
        Element encoded = doc.createElement(encodedElemName);
        Element grandchild = doc.createElement(grandChildElem);
        Attr attr = doc.createAttribute(attributeName);
        attr.setValue(attributeValue);
        Attr encodedAttr = doc.createAttribute(encodedAttributeName);
        encodedAttr.setValue(encodedAttributeValue);
        child.appendChild(encoded);
        child.setAttributeNode(encodedAttr);
        grandchild.setAttributeNode(attr);
        xmlElem.appendChild(doc.createTextNode(this.xmltext));
        xmlElem.appendChild(grandchild);
        xmlElem.setAttribute(attributeName, attributeValue);
        root.appendChild(child);
        root.appendChild(xmlElem);
        doc.appendChild(root);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importXML(String absPath, Document document, int uuidBehaviour, boolean withWorkspace) throws RepositoryException, IOException {
        this.serialize(document);
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(this.file));
        try {
            if (withWorkspace) {
                this.workspace.importXML(absPath, (InputStream)bin, uuidBehaviour);
            } else {
                this.session.importXML(absPath, (InputStream)bin, uuidBehaviour);
                this.session.save();
            }
        }
        finally {
            try {
                bin.close();
            }
            catch (IOException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importWithHandler(String absPath, Document document, int uuidBehaviour, boolean withWorkspace) throws Exception {
        this.serialize(document);
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(this.file));
        try {
            ContentHandler handler = withWorkspace ? this.workspace.getImportContentHandler(absPath, uuidBehaviour) : this.session.getImportContentHandler(absPath, uuidBehaviour);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            reader.setContentHandler(handler);
            reader.parse(new InputSource(bin));
            if (!withWorkspace) {
                this.session.save();
            }
        }
        finally {
            bin.close();
        }
    }

    public boolean isMixRefRespected() throws RepositoryException, IOException {
        boolean respected = false;
        if (this.supportsNodeType(this.mixReferenceable)) {
            String uuid;
            try {
                uuid = this.createReferenceableNode(this.referenced);
            }
            catch (NotExecutableException e) {
                return false;
            }
            Document document = this.dom.newDocument();
            Element root = document.createElement(rootElem);
            root.setAttribute("xmlns:jcr", "http://www.jcp.org/jcr/1.0");
            root.setAttributeNS("http://www.jcp.org/jcr/1.0", this.jcrUUID, uuid);
            root.setAttributeNS("http://www.jcp.org/jcr/1.0", this.jcrMixinTypes, this.mixReferenceable);
            document.appendChild(root);
            this.importXML(this.refTargetNode.getPath(), document, 1, false);
            this.session.save();
            respected = !this.testRootNode.hasNode(this.referenced);
            Node rootNode = this.refTargetNode.getNode(rootElem);
            respected &= rootNode.isNodeType(this.mixReferenceable);
        }
        return respected;
    }

    public String createReferenceableNode(String name) throws RepositoryException, NotExecutableException {
        try {
            Node node = this.testRootNode.getNode(name);
            node.remove();
            this.session.save();
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        Node n1 = this.testRootNode.addNode(name, this.testNodeType);
        if (!n1.isNodeType(this.mixReferenceable) && !n1.canAddMixin(this.mixReferenceable)) {
            n1.remove();
            this.session.save();
            throw new NotExecutableException("node type " + this.testNodeType + " does not support mix:referenceable");
        }
        n1.addMixin(this.mixReferenceable);
        this.testRootNode.getSession().save();
        return n1.getUUID();
    }

    public void importRefNodeDocument(String absPath, String uuid, int uuidBehaviour, boolean withWorkspace, boolean withHandler) throws Exception {
        Document document = this.dom.newDocument();
        Element root = document.createElement(rootElem);
        root.setAttribute("xmlns:jcr", "http://www.jcp.org/jcr/1.0");
        root.setAttributeNS("http://www.jcp.org/jcr/1.0", this.jcrUUID, uuid);
        root.setAttributeNS("http://www.jcp.org/jcr/1.0", this.jcrMixinTypes, this.mixReferenceable);
        root.setAttribute(this.propertyName1, "some text");
        document.appendChild(root);
        Node targetNode = null;
        try {
            targetNode = (Node)this.session.getItem(absPath);
            try {
                Node node = targetNode.getNode(rootElem);
                node.remove();
                this.session.save();
            }
            catch (PathNotFoundException pnfe) {}
        }
        catch (PathNotFoundException pnfe) {
            targetNode = this.createAncestors(absPath);
        }
        if (withHandler) {
            this.importWithHandler(targetNode.getPath(), document, uuidBehaviour, withWorkspace);
        } else {
            this.importXML(targetNode.getPath(), document, uuidBehaviour, withWorkspace);
        }
        this.session.save();
    }

    protected Node createAncestors(String absPath) throws RepositoryException {
        Node root = this.session.getRootNode();
        StringTokenizer names = new StringTokenizer(absPath, "/");
        Node currentNode = root;
        while (names.hasMoreTokens()) {
            String name = names.nextToken();
            if (currentNode.hasNode(name)) {
                currentNode = currentNode.getNode(name);
                continue;
            }
            currentNode = currentNode.addNode(name);
        }
        root.save();
        return currentNode;
    }

    public void serialize(Document document) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.file));
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("indent", "no");
            DOMSource s = new DOMSource(document);
            StreamResult r = new StreamResult(bos);
            t.transform(s, r);
        }
        catch (TransformerException te) {
            throw (IOException)new IOException(te.getMessage()).initCause(te);
        }
        finally {
            bos.close();
        }
    }

    public boolean supportsNodeType(String ntName) throws RepositoryException {
        boolean support = false;
        try {
            this.ntManager.getNodeType(ntName);
            support = true;
        }
        catch (NoSuchNodeTypeException noSuchNodeTypeException) {
            // empty catch block
        }
        return support;
    }

    protected String getUnusedPrefix() throws RepositoryException {
        HashSet<String> prefixes = new HashSet<String>(Arrays.asList(this.nsp.getPrefixes()));
        String prefix = "docview";
        int i = 0;
        while (prefixes.contains(prefix)) {
            prefix = "docview" + i++;
        }
        return prefix;
    }

    protected String getUnusedURI() throws RepositoryException {
        HashSet<String> uris = new HashSet<String>(Arrays.asList(this.nsp.getURIs()));
        String uri = "http://www.apache.org/jackrabbit/test/namespaceImportTest";
        int i = 0;
        while (uris.contains(uri)) {
            uri = "http://www.apache.org/jackrabbit/test/namespaceImportTest" + i++;
        }
        return uri;
    }
}

