/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.text.Normalizer;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class AddNodeTest
extends AbstractJCRTest {
    public void testName() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        AddNodeTest.assertEquals((String)"Wrong node name.", (String)n1.getName(), (String)this.nodeName1);
    }

    public void testNodeType() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        String ntName = n1.getPrimaryNodeType().getName();
        AddNodeTest.assertEquals((String)"Wrong node NodeType name.", (String)this.testNodeType, (String)ntName);
    }

    public void testSameNameSiblings() throws RepositoryException {
        if (this.testRootNode.getDefinition().allowsSameNameSiblings()) {
            Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            Node n2 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            this.testRootNode.getSession().save();
            AddNodeTest.assertEquals((String)"Names of same name siblings are not equal.", (String)n1.getName(), (String)n2.getName());
        } else {
            this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            try {
                this.testRootNode.addNode(this.nodeName1, this.testNodeType);
                AddNodeTest.fail((String)"Expected ItemExistsException.");
            }
            catch (ItemExistsException itemExistsException) {
                // empty catch block
            }
        }
    }

    public void testUnknownNodeType() throws RepositoryException {
        try {
            this.testRootNode.addNode(this.nodeName1, this.testNodeType + "unknownSuffix");
            AddNodeTest.fail((String)"Expected NoSuchNodeTypeException.");
        }
        catch (NoSuchNodeTypeException noSuchNodeTypeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAbstractNodeType() throws RepositoryException {
        NodeTypeManager ntMgr = this.superuser.getWorkspace().getNodeTypeManager();
        NodeTypeIterator nts = ntMgr.getPrimaryNodeTypes();
        while (nts.hasNext()) {
            NodeType nt = nts.nextNodeType();
            if (!nt.isAbstract()) continue;
            try {
                this.testRootNode.addNode(this.nodeName1, nt.getName());
                this.superuser.save();
                AddNodeTest.fail((String)"Expected ConstraintViolationException.");
            }
            catch (ConstraintViolationException e) {}
            continue;
            finally {
                this.superuser.refresh(false);
            }
        }
    }

    public void testMixinNodeType() throws RepositoryException, NotExecutableException {
        NodeTypeManager ntMgr = this.superuser.getWorkspace().getNodeTypeManager();
        NodeTypeIterator nts = ntMgr.getMixinNodeTypes();
        if (nts.hasNext()) {
            try {
                this.testRootNode.addNode(this.nodeName1, nts.nextNodeType().getName());
                this.superuser.save();
                AddNodeTest.fail((String)"Expected ConstraintViolationException.");
            }
            catch (ConstraintViolationException constraintViolationException) {}
        } else {
            throw new NotExecutableException("no mixins.");
        }
    }

    public void testPath() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        String expected = this.testRootNode.getPath() + "/" + this.nodeName1;
        AddNodeTest.assertEquals((String)"Wrong path for created node.", (String)expected, (String)n1.getPath());
    }

    public void testPathNotFound() throws RepositoryException {
        try {
            this.testRootNode.addNode(this.nodeName1 + "/" + this.nodeName1, this.testNodeType);
            AddNodeTest.fail((String)"Expected PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testConstraintViolation() throws RepositoryException {
        try {
            Node rootNode = this.superuser.getRootNode();
            String propPath = this.testPath + "/" + this.jcrPrimaryType;
            rootNode.addNode(propPath + "/" + this.nodeName1, this.testNodeType);
            AddNodeTest.fail((String)"Expected ConstraintViolationException.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testRepositoryException() {
        try {
            this.testRootNode.addNode(this.nodeName1 + "[1]");
            AddNodeTest.fail((String)"Expected RepositoryException.");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        try {
            this.testRootNode.addNode(this.nodeName1 + "[1]", this.testNodeType);
            AddNodeTest.fail((String)"Expected RepositoryException.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddNodeParentSave() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        defaultRootNode.save();
        Session session = this.getHelper().getReadOnlySession();
        try {
            session.getItem(testNode.getPath());
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddNodeSessionSave() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        Session session = this.getHelper().getReadOnlySession();
        try {
            session.getItem(testNode.getPath());
        }
        finally {
            session.logout();
        }
    }

    public void testAddNodeRepositoryExceptionSaveOnNewNode() throws RepositoryException {
        Node defaultRootNode = (Node)this.superuser.getItem(this.testRootNode.getPath());
        Node testNode = defaultRootNode.addNode(this.nodeName1, this.testNodeType);
        try {
            testNode.save();
            AddNodeTest.fail((String)"Calling Node.save() on a newly created node should throw RepositoryException");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testSimilarNodeNamesUpperLower() throws RepositoryException {
        this.internalTestSimilarNodeNames("Test-a", "Test-A");
    }

    public void testSimilarNodeNamesNfcNfd() throws RepositoryException {
        String precomposed = "Test-\u00e4";
        String decomposed = Normalizer.normalize(precomposed, Normalizer.Form.NFD);
        AddNodeTest.assertFalse((boolean)precomposed.equals(decomposed));
        this.internalTestSimilarNodeNames(precomposed, decomposed);
    }

    private void internalTestSimilarNodeNames(String name1, String name2) throws RepositoryException {
        Node n1 = null;
        Node n2 = null;
        Session s = this.testRootNode.getSession();
        try {
            n1 = this.testRootNode.addNode(name1);
            AddNodeTest.assertEquals((String)name1, (String)n1.getName());
            s.save();
            AddNodeTest.assertFalse((boolean)this.testRootNode.hasNode(name2));
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            n2 = this.testRootNode.addNode(name2);
            AddNodeTest.assertEquals((String)name2, (String)n2.getName());
            s.save();
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        if (n1 != null && n2 != null) {
            AddNodeTest.assertFalse((boolean)n1.isSame((Item)n2));
            AddNodeTest.assertFalse((boolean)n1.getIdentifier().equals(n2.getIdentifier()));
            String n2path = n2.getPath();
            n1.remove();
            s.save();
            Node n3 = s.getNode(n2path);
            AddNodeTest.assertTrue((boolean)n3.isSame((Item)n2));
        }
    }
}

