/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class NamespaceRegistryReadMethodsTest
extends AbstractJCRTest {
    private static final String[] BUILTIN_PREFIXES = new String[]{"jcr", "nt", "mix", "sv", ""};
    private static final String[] BUILTIN_URIS = new String[]{"http://www.jcp.org/jcr/1.0", "http://www.jcp.org/jcr/nt/1.0", "http://www.jcp.org/jcr/mix/1.0", "http://www.jcp.org/jcr/sv/1.0", ""};
    private NamespaceRegistry nsr;
    private Session session;

    @Override
    public void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        Workspace ws = this.session.getWorkspace();
        this.nsr = ws.getNamespaceRegistry();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.nsr = null;
        super.tearDown();
    }

    public void testGetNamespacePrefixes() throws RepositoryException {
        HashSet<String> prefixes = new HashSet<String>();
        prefixes.addAll(Arrays.asList(this.nsr.getPrefixes()));
        for (int i = 0; i < BUILTIN_PREFIXES.length; ++i) {
            String prefix = BUILTIN_PREFIXES[i];
            NamespaceRegistryReadMethodsTest.assertTrue((String)("NamespaceRegistry does not contain built in prefix: " + prefix), (boolean)prefixes.contains(prefix));
            String uri = this.nsr.getURI(prefix);
            NamespaceRegistryReadMethodsTest.assertEquals((String)("Wrong namespace mapping for prefix: " + prefix), (String)BUILTIN_URIS[i], (String)uri);
        }
    }

    public void testGetNamespaceURIs() throws RepositoryException {
        HashSet<String> uris = new HashSet<String>();
        uris.addAll(Arrays.asList(this.nsr.getURIs()));
        for (int i = 0; i < BUILTIN_URIS.length; ++i) {
            String uri = BUILTIN_URIS[i];
            NamespaceRegistryReadMethodsTest.assertTrue((String)("NamespaceRegistry does not contain built in uri: " + uri), (boolean)uris.contains(uri));
            String prefix = this.nsr.getPrefix(uri);
            NamespaceRegistryReadMethodsTest.assertEquals((String)("Wrong namespace mapping for uri: " + uri), (String)BUILTIN_PREFIXES[i], (String)prefix);
        }
    }

    public void testGetURINamespaceException() throws RepositoryException, NotExecutableException {
        HashSet<String> prefixes = new HashSet<String>();
        prefixes.addAll(Arrays.asList(this.nsr.getPrefixes()));
        String prefix = "myapp";
        int count = 0;
        while (prefixes.contains(prefix + count)) {
            ++count;
        }
        String testPrefix = prefix + count;
        try {
            this.nsr.getURI(testPrefix);
            NamespaceRegistryReadMethodsTest.fail((String)"NamespaceRegistry.getURI should throw a NamespaceException in case of an unmapped prefix.");
        }
        catch (NamespaceException nse) {
            // empty catch block
        }
    }

    public void testGetPrefixNamespaceException() throws RepositoryException, NotExecutableException {
        HashSet<String> uris = new HashSet<String>();
        uris.addAll(Arrays.asList(this.nsr.getURIs()));
        String uri = "http://www.unknown-company.com/namespace";
        int count = 0;
        while (uris.contains(uri + count)) {
            ++count;
        }
        String testURI = uri + count;
        try {
            this.nsr.getPrefix(testURI);
            NamespaceRegistryReadMethodsTest.fail((String)"NamespaceRegistry.getPrefix should throw a NamespaceException in case of an unregistered URI.");
        }
        catch (NamespaceException nse) {
            // empty catch block
        }
    }
}

