/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class NodeItemIsModifiedTest
extends AbstractJCRTest {
    public void testTransientNewNodeItemIsModified() throws RepositoryException {
        Node testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Item testNodeItem = this.superuser.getItem(testNode.getPath());
        NodeItemIsModifiedTest.assertFalse((String)"Item.isModified() must return false directly after a new NodeItem is added (before save of the parent node)", (boolean)testNodeItem.isModified());
    }

    public void testPersistentNewNodeItemIsModified() throws RepositoryException {
        Node testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        Item testNodeItem = this.superuser.getItem(testNode.getPath());
        NodeItemIsModifiedTest.assertFalse((String)"Item.isModified() must return false after a new NodeItem is added and the parent Node is saved", (boolean)testNodeItem.isModified());
    }

    public void testTransientNodeItemIsModified() throws RepositoryException {
        Node testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        testNode.setProperty(this.propertyName1, "test");
        Item testNodeItem = this.superuser.getItem(testNode.getPath());
        NodeItemIsModifiedTest.assertTrue((String)"Item.isModified() must return true directly after an existing NodeItem is modified (before current node is saved)", (boolean)testNodeItem.isModified());
    }

    public void testPersistentNodeItemIsModified() throws RepositoryException {
        Node testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        testNode.setProperty(this.propertyName1, "test");
        testNode.save();
        Item testNodeItem = this.superuser.getItem(testNode.getPath());
        NodeItemIsModifiedTest.assertFalse((String)"Item.isModified() must return false after an existing Property is modified and the current Node is saved", (boolean)testNodeItem.isModified());
    }
}

