/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetValueDoubleTest
extends AbstractJCRTest {
    private Value value;
    private Node node;
    private Property property1;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.value = this.superuser.getValueFactory().createValue(93845.94);
        this.node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureCanSetProperty(this.node, this.propertyName1, this.node.getSession().getValueFactory().createValue(0.0));
        this.property1 = this.node.setProperty(this.propertyName1, 0.0);
        this.superuser.save();
    }

    @Override
    protected void tearDown() throws Exception {
        this.value = null;
        this.node = null;
        this.property1 = null;
        super.tearDown();
    }

    public void testDoubleSession() throws RepositoryException {
        this.property1.setValue(this.value);
        this.superuser.save();
        SetValueDoubleTest.assertEquals((String)"Double node property not saved", (double)this.value.getDouble(), (double)this.property1.getValue().getDouble(), (double)0.0);
    }

    public void testDoubleParent() throws RepositoryException {
        this.property1.setValue(this.value.getDouble());
        this.node.save();
        SetValueDoubleTest.assertEquals((String)"Double node property not saved", (double)this.value.getDouble(), (double)this.property1.getValue().getDouble(), (double)0.0);
    }

    public void testRemoveDoubleSession() throws RepositoryException {
        this.property1.setValue((Value)null);
        this.superuser.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueDoubleTest.fail((String)"The property should not exist anymore, as a null Double has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveDoubleParent() throws RepositoryException {
        this.property1.setValue((Value)null);
        this.node.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueDoubleTest.fail((String)"The property should not exist anymore, as a null Double has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }
}

