/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetValueStringTest
extends AbstractJCRTest {
    private static final String PROP_VALUE_1 = "JCR";
    private static final String PROP_VALUE_2 = "JSR-170";
    private Property property1 = null;
    private Property property2 = null;
    private Node node = null;
    private Value sv1;
    private Value sv2 = null;
    private Value[] mv1;
    private Value[] mv2 = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sv1 = this.superuser.getValueFactory().createValue(PROP_VALUE_1);
        this.sv2 = this.superuser.getValueFactory().createValue(PROP_VALUE_2);
        this.mv1 = new Value[]{this.sv1};
        this.mv2 = new Value[]{this.sv1, this.sv2};
        this.node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        this.property1 = this.node.setProperty(this.propertyName1, PROP_VALUE_1);
        this.superuser.save();
        this.property2 = this.node.setProperty(this.propertyName2, this.mv1);
        this.superuser.save();
    }

    @Override
    protected void tearDown() throws Exception {
        this.property1 = null;
        this.property2 = null;
        this.node = null;
        this.sv1 = null;
        this.sv2 = null;
        this.mv1 = null;
        this.mv2 = null;
        super.tearDown();
    }

    public void testValueSession() throws RepositoryException {
        this.property1.setValue(this.sv2);
        this.superuser.save();
        SetValueStringTest.assertEquals((String)"Value node property not saved", (Object)this.sv2, (Object)this.property1.getValue());
    }

    public void testValueParent() throws RepositoryException {
        this.property1.setValue(this.sv2);
        this.testRootNode.getSession().save();
        SetValueStringTest.assertEquals((String)"Value node property not saved", (Object)this.sv2, (Object)this.property1.getValue());
    }

    public void testMultiValue() throws RepositoryException {
        Value[] mv = new Value[]{this.sv1, this.sv2};
        try {
            this.property1.setValue(mv);
            SetValueStringTest.fail((String)"Assigning multiple Value values to a single-valued property should throw a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testRemoveValueSession() throws RepositoryException {
        Value sv = null;
        this.property1.setValue(sv);
        this.superuser.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueStringTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveValueParent() throws RepositoryException {
        Value sv = null;
        this.property1.setValue(sv);
        this.node.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueStringTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testStringSession() throws RepositoryException {
        this.property1.setValue(PROP_VALUE_2);
        this.superuser.save();
        SetValueStringTest.assertEquals((String)"String node property not saved", (String)PROP_VALUE_2, (String)this.property1.getString());
    }

    public void testStringParent() throws RepositoryException {
        this.property1.setValue(PROP_VALUE_2);
        this.node.save();
        SetValueStringTest.assertEquals((String)"String node property not saved", (String)PROP_VALUE_2, (String)this.property1.getString());
    }

    public void testMultiString() throws RepositoryException {
        String[] mv = new String[]{PROP_VALUE_1, PROP_VALUE_2};
        try {
            this.property1.setValue(mv);
            SetValueStringTest.fail((String)"Assigning multiple String values to a single-valued property should throw a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testRemoveStringSession() throws RepositoryException {
        String sv = null;
        this.property1.setValue(sv);
        this.superuser.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueStringTest.fail((String)"The property should not exist anymore, as a null String has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveStringParent() throws RepositoryException {
        String sv = null;
        this.property1.setValue(sv);
        this.node.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueStringTest.fail((String)"The property should not exist anymore, as a null String has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testMultiValueSession() throws RepositoryException {
        this.property2.setValue(this.mv2);
        this.superuser.save();
        SetValueStringTest.assertEquals((String)"Node property not saved", Arrays.asList(this.mv2), Arrays.asList(this.property2.getValues()));
    }

    public void testMultiValueParent() throws RepositoryException {
        this.property2.setValue(this.mv2);
        this.node.save();
        SetValueStringTest.assertEquals((String)"Node property not saved", Arrays.asList(this.mv2), Arrays.asList(this.property2.getValues()));
    }

    public void testMultiValueSingle() throws RepositoryException {
        try {
            this.property2.setValue(this.sv1);
            SetValueStringTest.fail((String)"Assigning a single Value value to a multi-valued property should throw a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testRemoveMultiValueSession() throws RepositoryException {
        this.property2.setValue((Value[])null);
        this.superuser.save();
        try {
            this.node.getProperty(this.propertyName2);
            SetValueStringTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveMultiValueParent() throws RepositoryException {
        this.property2.setValue((Value[])null);
        this.node.save();
        try {
            this.node.getProperty(this.propertyName2);
            SetValueStringTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testNullMultiValue() throws RepositoryException {
        this.property2.setValue(new Value[]{null, this.sv2});
        this.superuser.save();
        SetValueStringTest.assertEquals((String)"Null value not removed", Arrays.asList(this.property2.getValues()), Arrays.asList(this.sv2));
    }

    public void testMultiStringSession() throws RepositoryException {
        String[] mv = new String[]{PROP_VALUE_1, PROP_VALUE_2};
        this.property2.setValue(mv);
        this.superuser.save();
        Value[] values = this.property2.getValues();
        ArrayList<String> strValues = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            strValues.add(values[i].getString());
        }
        SetValueStringTest.assertEquals((String)"Node property not saved", Arrays.asList(mv), strValues);
    }

    public void testMultiStringParent() throws RepositoryException {
        String[] mv = new String[]{PROP_VALUE_1, PROP_VALUE_2};
        this.property2.setValue(mv);
        this.node.save();
        Value[] values = this.property2.getValues();
        ArrayList<String> strValues = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            strValues.add(values[i].getString());
        }
        SetValueStringTest.assertEquals((String)"Node property not saved", Arrays.asList(mv), strValues);
    }

    public void testMultiStringSingle() throws RepositoryException {
        try {
            this.property2.setValue(PROP_VALUE_1);
            SetValueStringTest.fail((String)"Assigning a single String value to a multi-valued property should throw a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testRemoveMultiStringSession() throws RepositoryException {
        this.property2.setValue((String[])null);
        this.superuser.save();
        try {
            this.node.getProperty(this.propertyName2);
            SetValueStringTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveMultiStringParent() throws RepositoryException {
        this.property2.setValue((String[])null);
        this.node.save();
        try {
            this.node.getProperty(this.propertyName2);
            SetValueStringTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testEmptyMultiStringParent() throws RepositoryException {
        String[] emptyStringArray = new String[]{null};
        this.property2.setValue(emptyStringArray);
        this.node.save();
        SetValueStringTest.assertEquals((String)"Property.setValue(emptyStringArray) did not set the property to an empty array", (int)0, (int)this.property2.getValues().length);
    }

    public void testEmptyMultiStringSession() throws RepositoryException {
        String[] emptyStringArray = new String[]{null};
        this.property2.setValue(emptyStringArray);
        this.superuser.save();
        SetValueStringTest.assertEquals((String)"Property.setValue(emptyStringArray) did not set the property to an empty array", (int)0, (int)this.property2.getValues().length);
    }
}

