/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.Statement;
import org.apache.jackrabbit.test.api.util.ISO9075;

public abstract class AbstractQueryTest
extends AbstractJCRTest {
    protected String jcrScore;
    protected String jcrPath;
    protected String jcrRoot;
    protected String jcrContains;
    protected String jcrDeref;
    protected String xpathRoot;
    protected QueryObjectModelFactory qf;
    protected ValueFactory vf;
    protected QueryManager qm;
    protected String qsXPATH = "xpath";
    protected String qsSQL = "sql";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.jcrScore = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":score";
        this.jcrPath = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":path";
        this.jcrRoot = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":root";
        this.jcrContains = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":contains";
        this.jcrDeref = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":deref";
        this.xpathRoot = "/" + this.jcrRoot + ISO9075.encodePath(this.testRoot);
        this.qm = this.superuser.getWorkspace().getQueryManager();
        this.qf = this.qm.getQOMFactory();
        this.vf = this.superuser.getValueFactory();
    }

    @Override
    protected void tearDown() throws Exception {
        this.qm = null;
        this.qf = null;
        this.vf = null;
        super.tearDown();
    }

    protected Query createQuery(Statement statement) throws RepositoryException, NotExecutableException {
        return this.createQuery(statement.getStatement(), statement.getLanguage());
    }

    protected Query createQuery(String statement, String language) throws RepositoryException, NotExecutableException {
        return this.createQuery(this.superuser, statement, language);
    }

    protected Query createQuery(Session session, String statement, String language) throws RepositoryException, NotExecutableException {
        this.log.println("Creating query: " + statement);
        if (!this.isSupportedLanguage(language) && !"JCR-SQL2".equals(language)) {
            throw new NotExecutableException("Repository does not support " + language + " query syntax");
        }
        return session.getWorkspace().getQueryManager().createQuery(statement, language);
    }

    protected QueryResult execute(Statement statement) throws RepositoryException, NotExecutableException {
        return this.execute(statement.getStatement(), statement.getLanguage());
    }

    protected QueryResult execute(String statement, String language) throws RepositoryException, NotExecutableException {
        Query query = this.createQuery(statement, language);
        return query.execute();
    }

    protected void checkResult(QueryResult result, int hits) throws RepositoryException {
        RowIterator itr = result.getRows();
        long count = itr.getSize();
        if (count == 0L) {
            this.log.println(" NONE");
        } else if (count == -1L) {
            count = 0L;
            while (itr.hasNext()) {
                itr.nextRow();
                ++count;
            }
        }
        AbstractQueryTest.assertEquals((String)"Wrong hit count.", (long)hits, (long)count);
    }

    protected void checkResult(QueryResult result, int hits, int properties) throws RepositoryException {
        this.checkResult(result, hits);
        int count = 0;
        this.log.println("Properties:");
        String[] propNames = result.getColumnNames();
        RowIterator it = result.getRows();
        while (it.hasNext()) {
            StringBuffer msg = new StringBuffer();
            Value[] values = it.nextRow().getValues();
            int i = 0;
            while (i < propNames.length) {
                msg.append("  ").append(propNames[i]).append(": ");
                if (values[i] == null) {
                    msg.append("null");
                } else {
                    msg.append(values[i].getString());
                }
                ++i;
                ++count;
            }
            this.log.println(msg);
        }
        if (count == 0) {
            this.log.println("  NONE");
        }
        AbstractQueryTest.assertEquals((String)"Wrong property count.", (int)properties, (int)count);
    }

    protected void evaluateResultOrder(QueryResult queryResult, String propName, boolean descending) throws RepositoryException, NotExecutableException {
        String last;
        NodeIterator nodes = queryResult.getNodes();
        if (this.getSize((RangeIterator)nodes) < 2L) {
            AbstractQueryTest.fail((String)"Workspace does not contain sufficient content to test ordering on result nodes.");
        }
        nodes = queryResult.getNodes();
        int changeCnt = 0;
        String string = last = descending ? "\uffff" : "";
        while (nodes.hasNext()) {
            String value = nodes.nextNode().getProperty(propName).getString();
            int cp = value.compareTo(last);
            if (cp != 0) {
                ++changeCnt;
                if (cp > 0 && descending) {
                    AbstractQueryTest.fail((String)"Repository doesn't order properly descending");
                } else if (cp < 0 && !descending) {
                    AbstractQueryTest.fail((String)"Repository doesn't order properly ascending");
                }
            }
            last = value;
        }
        if (changeCnt < 1) {
            AbstractQueryTest.fail((String)("Workspace does not contain distinct values for " + propName));
        }
    }

    protected void executeXPathQuery(Session session, String xpath, Node[] expectedNodes) throws RepositoryException, NotExecutableException {
        QueryResult res = this.createQuery(session, xpath, this.qsXPATH).execute();
        this.checkResult(res, expectedNodes, null);
    }

    protected void executeSqlQuery(Session session, String sql, Node[] expectedNodes) throws RepositoryException, NotExecutableException {
        this.executeSqlQuery(session, sql, expectedNodes, null);
    }

    protected void executeSqlQuery(Session session, String sql, Node[] requiredNodes, Node[] optionalNodes) throws RepositoryException, NotExecutableException {
        QueryResult res = this.createQuery(session, sql, this.qsSQL).execute();
        this.checkResult(res, requiredNodes, optionalNodes);
    }

    protected void checkResult(QueryResult result, Node[] expectedNodes) throws RepositoryException {
        this.checkResult(result, expectedNodes, null);
    }

    protected void checkResult(QueryResult result, Node[] requiredNodes, Node[] optionalNodes) throws RepositoryException {
        HashSet<String> requiredPaths = AbstractQueryTest.getPathSet(requiredNodes);
        HashSet<String> optionalPaths = AbstractQueryTest.getPathSet(optionalNodes);
        HashSet<String> resultPaths = new HashSet<String>();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            resultPaths.add(it.nextNode().getPath());
        }
        for (String path : requiredPaths) {
            AbstractQueryTest.assertTrue((String)(path + " is not part of the result set"), (boolean)resultPaths.contains(path));
        }
        for (String path : resultPaths) {
            if (optionalPaths.contains(path)) continue;
            AbstractQueryTest.assertTrue((String)(path + " is not expected to be part of the result set"), (boolean)requiredPaths.contains(path));
        }
    }

    private static HashSet<String> getPathSet(Node[] nodes) throws RepositoryException {
        HashSet<String> paths = new HashSet<String>();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                paths.add(nodes[i].getPath());
            }
        }
        return paths;
    }

    protected Node[] toArray(NodeIterator it) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        while (it.hasNext()) {
            nodes.add(it.nextNode());
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    protected String escapeIdentifierForSQL(String identifier) {
        boolean needsEscaping;
        boolean bl = needsEscaping = identifier.indexOf(45) >= 0;
        if (!needsEscaping) {
            return identifier;
        }
        return '\"' + identifier + '\"';
    }

    protected boolean isSupportedLanguage(String language) throws RepositoryException {
        return Arrays.asList(this.qm.getSupportedQueryLanguages()).contains(language);
    }
}

