/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import java.util.Arrays;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class SimpleSelectionTest
extends AbstractQueryTest {
    private Session session;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.testRootNode = this.session.getRootNode().getNode(this.testPath);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testSingleProperty() throws RepositoryException, NotExecutableException {
        if (!this.testRootNode.hasNodes()) {
            throw new NotExecutableException("Workspace does not contains enough content.");
        }
        String firstChildpath = this.testRootNode.getNodes().nextNode().getPath();
        String propQuery = "/" + this.jcrRoot + firstChildpath + "[@" + this.jcrPrimaryType + "]";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(propQuery, this.qsXPATH);
        QueryResult result = query.execute();
        SimpleSelectionTest.assertEquals((String)"Should have only 1 result", (long)1L, (long)this.getSize((RangeIterator)result.getRows()));
        SimpleSelectionTest.assertTrue((String)"Should contain the searched property", (boolean)Arrays.asList(result.getColumnNames()).contains(this.jcrPrimaryType));
    }
}

