/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class XPathJcrPathTest
extends AbstractQueryTest {
    private Session session;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.testRootNode = this.session.getRootNode().getNode(this.testPath);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testJcrPath() throws RepositoryException, NotExecutableException {
        String nodeTypeName = this.session.getRootNode().getPrimaryNodeType().getName();
        String queryStatement = "//element(*, " + nodeTypeName + ")";
        Query query = this.session.getWorkspace().getQueryManager().createQuery(queryStatement, this.qsXPATH);
        QueryResult result = query.execute();
        XPathJcrPathTest.assertTrue((String)"jcr:path must be present in query result row", (boolean)Arrays.asList(result.getColumnNames()).contains(this.jcrPath));
    }
}

