/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public class DescendantNodeTest
extends AbstractQOMTest {
    public void testDescendantNode() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.descendantNode("s", this.testRoot), null, null);
        this.checkQOM(qom, new Node[]{n});
    }

    public void testDescendantNodes() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        Node n21 = n2.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.descendantNode("s", this.testRoot), null, null);
        this.checkQOM(qom, new Node[]{n1, n2, n21});
    }

    public void testPathDoesNotExist() throws RepositoryException {
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.descendantNode("s", this.testRoot + "/" + this.nodeName1), null, null);
        this.checkQOM(qom, new Node[0]);
    }

    public void testDescendantNodesDoNotMatchSelector() throws RepositoryException, NotExecutableException {
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        NodeTypeManager ntMgr = this.superuser.getWorkspace().getNodeTypeManager();
        NodeTypeIterator it = ntMgr.getPrimaryNodeTypes();
        NodeType testNt = ntMgr.getNodeType(this.testNodeType);
        while (it.hasNext()) {
            NodeType nt = it.nextNodeType();
            if (testNt.isNodeType(nt.getName())) continue;
            QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(nt.getName(), "s"), (Constraint)this.qf.descendantNode("s", this.testRoot), null, null);
            this.checkQOM(qom, new Node[0]);
            return;
        }
        throw new NotExecutableException("No suitable node type found to perform test against '" + this.testNodeType + "' nodes");
    }

    public void testRelativePath() throws RepositoryException {
        try {
            QueryObjectModel q = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.descendantNode("s", this.testPath), null, null);
            q.execute();
            DescendantNodeTest.fail((String)"DescendantNode with relative path argument must throw InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS s WHERE " + "ISDESCENDANTNODE(s, [" + this.testPath + "])";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            DescendantNodeTest.fail((String)"ISDESCENDANTNODE() with relative path argument must throw InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testSyntacticallyInvalidPath() throws RepositoryException {
        String invalidPath = this.testRoot + "/" + this.nodeName1 + "[";
        try {
            QueryObjectModel q = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.descendantNode("s", invalidPath), null, null);
            q.execute();
            DescendantNodeTest.fail((String)"DescendantNode with syntactically invalid path argument must throw InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS s WHERE " + "ISDESCENDANTNODE(s, [" + invalidPath + "])";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            DescendantNodeTest.fail((String)"ISDESCENDANTNODE() with syntactically invalid path argument must throw InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    public void testNotASelectorName() throws RepositoryException {
        try {
            QueryObjectModel q = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.descendantNode("x", this.testRoot), null, null);
            q.execute();
            DescendantNodeTest.fail((String)"DescendantNode with an unknown selector name must throw InvalidQueryException");
        }
        catch (InvalidQueryException e) {
            // empty catch block
        }
        try {
            String stmt = "SELECT * FROM [" + this.testNodeType + "] AS s WHERE " + "ISDESCENDANTNODE(x, [" + this.testRoot + "])";
            this.qm.createQuery(stmt, "JCR-SQL2").execute();
            DescendantNodeTest.fail((String)"ISDESCENDANTNODE() with an unknown selector name must throw InvalidQueryException");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }
}

