/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.security;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public abstract class AbstractAccessControlTest
extends AbstractJCRTest {
    protected AccessControlManager acMgr;

    @Override
    protected void setUp() throws Exception {
        this.checkSupportedOption("option.access.control.supported");
        super.setUp();
        try {
            this.acMgr = AbstractAccessControlTest.getAccessControlManager(this.superuser);
        }
        catch (NotExecutableException e) {
            this.cleanUp();
            throw e;
        }
    }

    protected static AccessControlManager getAccessControlManager(Session s) throws RepositoryException, NotExecutableException {
        try {
            return s.getAccessControlManager();
        }
        catch (UnsupportedRepositoryOperationException e) {
            throw new NotExecutableException();
        }
    }

    protected Privilege[] privilegesFromName(String privilegeName) throws RepositoryException, NotExecutableException {
        AccessControlManager acMgr = AbstractAccessControlTest.getAccessControlManager(this.superuser);
        return new Privilege[]{acMgr.privilegeFromName(privilegeName)};
    }

    protected Privilege[] privilegesFromNames(String[] privilegeNames) throws RepositoryException, NotExecutableException {
        AccessControlManager acMgr = AbstractAccessControlTest.getAccessControlManager(this.superuser);
        Privilege[] privs = new Privilege[privilegeNames.length];
        for (int i = 0; i < privilegeNames.length; ++i) {
            privs[i] = acMgr.privilegeFromName(privilegeNames[i]);
        }
        return privs;
    }

    protected void checkCanReadAc(String path) throws RepositoryException, NotExecutableException {
        if (!this.acMgr.hasPrivileges(path, this.privilegesFromName("{http://www.jcp.org/jcr/1.0}readAccessControl"))) {
            throw new NotExecutableException();
        }
    }

    protected void checkCanModifyAc(String path) throws RepositoryException, NotExecutableException {
        if (!this.acMgr.hasPrivileges(path, this.privilegesFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl"))) {
            throw new NotExecutableException();
        }
    }

    protected String getPathToNonExistingNode() throws RepositoryException {
        String name;
        String path = name = "nonexisting";
        int i = 0;
        while (this.testRootNode.hasNode(path)) {
            path = name + i;
            ++i;
        }
        path = this.testRootNode.getPath() + "/" + path;
        return path;
    }

    protected String getPathToProperty() throws RepositoryException {
        String path = this.testRootNode.getPath() + "/" + this.jcrPrimaryType;
        if (this.superuser.nodeExists(path)) {
            throw new RepositoryException("Path " + path + " should point to property.");
        }
        return path;
    }
}

