/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractOnParentVersionTest;

public class OnParentVersionCopyTest
extends AbstractOnParentVersionTest {
    String initialNodePath;

    @Override
    protected void setUp() throws Exception {
        this.OPVAction = 1;
        super.setUp();
    }

    public void testRestoreProp() throws RepositoryException {
        OnParentVersionCopyTest.assertEquals((String)"On restore of a OnParentVersion-COPY property P the copy of P stored will be restored, replacing the current P in the workspace.", (String)this.p.getString(), (String)this.initialPropValue);
    }

    public void testRestoreNode() throws RepositoryException {
        Node childNode = this.addChildNode(this.OPVAction);
        Node nodeParent = childNode.getParent();
        nodeParent.save();
        nodeParent.checkout();
        Version v = nodeParent.checkin();
        this.initialNodePath = childNode.getPath();
        nodeParent.checkout();
        childNode.remove();
        nodeParent.save();
        nodeParent.restore(v, false);
        if (!this.superuser.itemExists(this.initialNodePath)) {
            OnParentVersionCopyTest.fail((String)"On restore of a OnParentVersion-COPY child node, the node needs to be restored, replacing the current node in the workspace.");
        }
    }

    public void testRestoreNodeJcr2() throws RepositoryException {
        Node childNode = this.addChildNode(this.OPVAction);
        Node nodeParent = childNode.getParent();
        nodeParent.getSession().save();
        VersionManager versionManager = nodeParent.getSession().getWorkspace().getVersionManager();
        String path = nodeParent.getPath();
        versionManager.checkout(path);
        Version v = versionManager.checkin(path);
        this.initialNodePath = childNode.getPath();
        versionManager.checkout(path);
        childNode.remove();
        nodeParent.getSession().save();
        versionManager.restore(v, false);
        if (!this.superuser.itemExists(this.initialNodePath)) {
            OnParentVersionCopyTest.fail((String)"On restore of a OnParentVersion-COPY child node, the node needs to be restored, replacing the current node in the workspace.");
        }
    }
}

