/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class RestoreTest
extends AbstractVersionTest {
    VersionManager versionManager;
    Version version;
    Version version2;
    Version rootVersion;
    Node versionableNode2;
    String propertyValue1;
    String propertyValue2;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        this.propertyValue1 = this.getProperty("propertyValue1");
        this.propertyValue2 = this.getProperty("propertyValue2");
        this.versionableNode.setProperty(this.propertyName1, this.propertyValue1);
        this.versionableNode.getSession().save();
        this.version = this.versionManager.checkin(path);
        this.versionManager.checkout(path);
        this.versionableNode.setProperty(this.propertyName1, this.propertyValue2);
        this.versionableNode.getSession().save();
        this.version2 = this.versionManager.checkin(path);
        this.versionManager.checkout(path);
        this.rootVersion = this.versionManager.getVersionHistory(path).getRootVersion();
        try {
            this.versionableNode2 = this.createVersionableNode(this.testRootNode, this.nodeName2, this.versionableNodeType);
        }
        catch (RepositoryException e) {
            RestoreTest.fail((String)("Failed to create a second versionable node: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            this.versionableNode2.remove();
            this.testRootNode.getSession().save();
        }
        finally {
            this.version = null;
            this.version2 = null;
            this.rootVersion = null;
            this.versionableNode2 = null;
            super.tearDown();
        }
    }

    public void testRestoreRootVersionFail() throws RepositoryException {
        try {
            this.versionableNode.restore(this.rootVersion, true);
            RestoreTest.fail((String)"Restore of jcr:rootVersion must throw VersionException.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreRootVersionFailJcr2() throws RepositoryException {
        try {
            this.versionManager.restore(this.rootVersion, true);
            RestoreTest.fail((String)"Restore of jcr:rootVersion must throw VersionException.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreOnCheckedInNode() throws RepositoryException {
        this.versionableNode.checkin();
        this.versionableNode.restore(this.version, true);
    }

    public void testRestoreOnCheckedInNodeJcr2_1() throws RepositoryException {
        this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.restore(this.version, true);
    }

    public void testRestoreOnCheckedInNodeJcr2_2() throws RepositoryException {
        this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.restore(this.version, true);
    }

    public void testRestoreOnCheckedInNodeJcr2_3() throws RepositoryException {
        this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.restore(this.versionableNode.getPath(), this.version.getName(), true);
    }

    public void testRestoreOnCheckedInNodeJcr2_4() throws RepositoryException {
        this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.restore(new Version[]{this.version}, true);
    }

    public void testRestoreOnCheckedOutNode() throws RepositoryException {
        this.versionableNode.restore(this.version, true);
    }

    public void testRestoreOnCheckedOutNodeJcr2() throws RepositoryException {
        this.versionManager.restore(this.version, true);
    }

    public void testRestoreOnCheckedOutNodeJcr2_2() throws RepositoryException {
        this.versionManager.restore(this.version, true);
    }

    public void testRestoreOnCheckedOutNodeJcr2_3() throws RepositoryException {
        this.versionManager.restore(this.versionableNode.getPath(), this.version.getName(), true);
    }

    public void testRestoreOnCheckedOutNodeJcr2_4() throws RepositoryException {
        this.versionManager.restore(new Version[]{this.version}, true);
    }

    public void testRestoreSetsIsCheckedOutToFalse() throws RepositoryException {
        this.versionableNode.restore(this.version, true);
        RestoreTest.assertFalse((String)"Restoring a node sets the jcr:isCheckedOut property to false", (boolean)this.versionableNode.isCheckedOut());
    }

    public void testRestoreSetsIsCheckedOutToFalseJcr2() throws RepositoryException {
        this.versionManager.restore(this.version, true);
        RestoreTest.assertFalse((String)"Restoring a node sets the jcr:isCheckedOut property to false", (boolean)this.versionManager.isCheckedOut(this.versionableNode.getPath()));
    }

    public void testRestoreSetsIsCheckedOutToFalseJcr2_2() throws RepositoryException {
        this.versionManager.restore(this.version, true);
        RestoreTest.assertFalse((String)"Restoring a node sets the jcr:isCheckedOut property to false", (boolean)this.versionManager.isCheckedOut(this.versionableNode.getPath()));
    }

    public void testRestoreSetsIsCheckedOutToFalseJcr3() throws RepositoryException {
        this.versionManager.restore(this.versionableNode.getPath(), this.version.getName(), true);
        RestoreTest.assertFalse((String)"Restoring a node sets the jcr:isCheckedOut property to false", (boolean)this.versionManager.isCheckedOut(this.versionableNode.getPath()));
    }

    public void testRestoreSetsIsCheckedOutToFalseJcr2_4() throws RepositoryException {
        this.versionManager.restore(new Version[]{this.version}, true);
        RestoreTest.assertFalse((String)"Restoring a node sets the jcr:isCheckedOut property to false", (boolean)this.versionManager.isCheckedOut(this.versionableNode.getPath()));
    }

    public void testRestoreCorrectProperty() throws RepositoryException {
        this.versionableNode.restore(this.version, true);
        String value = this.versionableNode.getProperty(this.propertyName1).getString();
        RestoreTest.assertEquals((String)"Restoring a node must set the correct property.", (String)this.propertyValue1, (String)value);
    }

    public void testRestoreCorrectPropertyJcr2() throws RepositoryException {
        this.versionManager.restore(this.version, true);
        String value = this.versionableNode.getProperty(this.propertyName1).getString();
        RestoreTest.assertEquals((String)"Restoring a node must set the correct property.", (String)this.propertyValue1, (String)value);
    }

    public void testRestoreCorrectPropertyJcr2_2() throws RepositoryException {
        this.versionManager.restore(this.version, true);
        String value = this.versionableNode.getProperty(this.propertyName1).getString();
        RestoreTest.assertEquals((String)"Restoring a node must set the correct property.", (String)this.propertyValue1, (String)value);
    }

    public void testRestoreCorrectPropertyJcr2_3() throws RepositoryException {
        this.versionManager.restore(this.versionableNode.getPath(), this.version.getName(), true);
        String value = this.versionableNode.getProperty(this.propertyName1).getString();
        RestoreTest.assertEquals((String)"Restoring a node must set the correct property.", (String)this.propertyValue1, (String)value);
    }

    public void testRestoreCorrectPropertyJcr2_4() throws RepositoryException {
        this.versionManager.restore(new Version[]{this.version}, true);
        String value = this.versionableNode.getProperty(this.propertyName1).getString();
        RestoreTest.assertEquals((String)"Restoring a node must set the correct property.", (String)this.propertyValue1, (String)value);
    }

    public void testRestoreSetsBaseVersion() throws RepositoryException {
        this.versionableNode.restore(this.version, true);
        Version baseV = this.versionableNode.getBaseVersion();
        RestoreTest.assertTrue((String)"Restoring a node must set node's base version in order to point to the restored version.", (boolean)this.version.isSame((Item)baseV));
    }

    public void testRestoreSetsBaseVersionJcr2() throws RepositoryException {
        this.versionManager.restore(this.version, true);
        Version baseV = this.versionManager.getBaseVersion(this.versionableNode.getPath());
        RestoreTest.assertTrue((String)"Restoring a node must set node's base version in order to point to the restored version.", (boolean)this.version.isSame((Item)baseV));
    }

    public void testRestoreSetsBaseVersionJcr2_2() throws RepositoryException {
        this.versionManager.restore(this.version, true);
        Version baseV = this.versionManager.getBaseVersion(this.versionableNode.getPath());
        RestoreTest.assertTrue((String)"Restoring a node must set node's base version in order to point to the restored version.", (boolean)this.version.isSame((Item)baseV));
    }

    public void testRestoreSetsBaseVersionJcr2_3() throws RepositoryException {
        this.versionManager.restore(this.versionableNode.getPath(), this.version.getName(), true);
        Version baseV = this.versionManager.getBaseVersion(this.versionableNode.getPath());
        RestoreTest.assertTrue((String)"Restoring a node must set node's base version in order to point to the restored version.", (boolean)this.version.isSame((Item)baseV));
    }

    public void testRestoreSetsBaseVersionJcr2_4() throws RepositoryException {
        this.versionManager.restore(new Version[]{this.version}, true);
        Version baseV = this.versionManager.getBaseVersion(this.versionableNode.getPath());
        RestoreTest.assertTrue((String)"Restoring a node must set node's base version in order to point to the restored version.", (boolean)this.version.isSame((Item)baseV));
    }

    public void testRestoreWithPendingChanges() throws RepositoryException {
        try {
            this.versionableNode.setProperty(this.propertyName1, this.propertyValue);
            this.versionableNode.restore(this.version, true);
            RestoreTest.fail((String)"InvalidItemStateException must be thrown on attempt to restore a node having any unsaved changes pending.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testRestoreWithPendingChangesJcr2() throws RepositoryException {
        try {
            this.versionableNode.setProperty(this.propertyName1, this.propertyValue);
            this.versionManager.restore(this.version, true);
            RestoreTest.fail((String)"InvalidItemStateException must be thrown on attempt to restore a node having any unsaved changes pending.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testRestoreWithPendingChangesJcr2_2() throws RepositoryException {
        try {
            this.versionableNode.setProperty(this.propertyName1, this.propertyValue);
            this.versionManager.restore(this.version, true);
            RestoreTest.fail((String)"InvalidItemStateException must be thrown on attempt to restore a node having any unsaved changes pending.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testRestoreWithPendingChangesJcr2_3() throws RepositoryException {
        try {
            this.versionableNode.setProperty(this.propertyName1, this.propertyValue);
            this.versionManager.restore(this.versionableNode.getPath(), this.version.getName(), true);
            RestoreTest.fail((String)"InvalidItemStateException must be thrown on attempt to restore a node having any unsaved changes pending.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testRestoreWithPendingChangesJcr2_4() throws RepositoryException {
        try {
            this.versionableNode.setProperty(this.propertyName1, this.propertyValue);
            this.versionManager.restore(new Version[]{this.version}, true);
            RestoreTest.fail((String)"InvalidItemStateException must be thrown on attempt to restore a node having any unsaved changes pending.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testRestoreInvalidVersion() throws RepositoryException {
        Version vNode2 = this.versionableNode2.checkin();
        try {
            this.versionableNode.restore(vNode2, true);
            RestoreTest.fail((String)"VersionException expected on Node.restore(Version, boolean) if the specified version is not part of this node's version history.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreInvalidVersionJcr2() throws RepositoryException {
        Version vNode2 = this.versionManager.checkin(this.versionableNode2.getPath());
        try {
            this.versionManager.restore(this.versionableNode.getPath(), vNode2, true);
            RestoreTest.fail((String)"VersionException expected on Node.restore(Version, boolean) if the specified version is not part of this node's version history.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreInvalidVersion2() throws RepositoryException {
        String invalidName;
        block2: do {
            invalidName = this.createRandomString(3);
            VersionIterator it = this.versionableNode.getVersionHistory().getAllVersions();
            while (it.hasNext()) {
                Version v = it.nextVersion();
                if (!invalidName.equals(v.getName())) continue;
                invalidName = null;
                continue block2;
            }
        } while (invalidName == null);
        try {
            this.versionableNode.restore(invalidName, true);
            RestoreTest.fail((String)"VersionException expected on Node.restore(String, boolean) if the specified version is not part of this node's version history.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreInvalidVersion2Jcr2() throws RepositoryException {
        String invalidName;
        block2: do {
            invalidName = this.createRandomString(3);
            VersionIterator it = this.versionManager.getVersionHistory(this.versionableNode.getPath()).getAllVersions();
            while (it.hasNext()) {
                Version v = it.nextVersion();
                if (!invalidName.equals(v.getName())) continue;
                invalidName = null;
                continue block2;
            }
        } while (invalidName == null);
        try {
            this.versionManager.restore(this.versionableNode.getPath(), invalidName, true);
            RestoreTest.fail((String)"VersionException expected on Node.restore(String, boolean) if the specified version is not part of this node's version history.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreNonVersionableNode() throws RepositoryException {
        try {
            this.nonVersionableNode.restore("foo", true);
            RestoreTest.fail((String)"Node.restore(String, boolean) on a non versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreNonVersionableNodeJcr2_2() throws RepositoryException {
        try {
            this.versionManager.restore(this.nonVersionableNode.getPath(), "foo", true);
            RestoreTest.fail((String)"trying to restore on a non versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreNonVersionableNode2() throws RepositoryException {
        try {
            this.nonVersionableNode.getParent().restore(this.version, this.nonVersionableNode.getName(), true);
            RestoreTest.fail((String)"Node.restore(Version, String, boolean) on a non versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreNonVersionableNode3() throws RepositoryException {
        try {
            this.nonVersionableNode.restore(this.version, true);
            RestoreTest.fail((String)"Node.restore(Version, boolean) on a non versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreNonVersionableNode3Jcr2_2() throws RepositoryException {
        try {
            this.versionManager.restore(this.nonVersionableNode.getPath(), this.version.getName(), true);
            RestoreTest.fail((String)"Node.restore(Version, boolean) on a non versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreWithInvalidVersion() throws RepositoryException {
        Version invalidVersion = this.versionableNode2.checkin();
        try {
            this.versionableNode.restore(invalidVersion, true);
            RestoreTest.fail((String)"Node.restore(Version, boolean): A VersionException must be thrown if the specified version does not exists in this node's version history.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreWithInvalidVersionJcr2() throws RepositoryException {
        Version invalidVersion = this.versionManager.checkin(this.versionableNode2.getPath());
        try {
            this.versionManager.restore(this.versionableNode.getPath(), invalidVersion, true);
            RestoreTest.fail((String)"Node.restore(Version, boolean): A VersionException must be thrown if the specified version does not exists in this node's version history.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreWithUUIDConflict() throws RepositoryException, NotExecutableException {
        try {
            Node naa = this.createVersionableNode(this.versionableNode, this.nodeName4, this.versionableNodeType);
            NodeDefinition nd = naa.getDefinition();
            if (nd.getOnParentVersion() != 1 && nd.getOnParentVersion() != 2) {
                throw new NotExecutableException("Child nodes must have OPV COPY or VERSION in order to be able to test Node.restore with uuid conflict.");
            }
            Version v = this.versionableNode.checkin();
            this.versionableNode.checkout();
            this.superuser.move(naa.getPath(), this.versionableNode2.getPath() + "/" + naa.getName());
            this.superuser.save();
            this.versionableNode.restore(v, false);
            RestoreTest.fail((String)"Node.restore( Version, boolean ): An ItemExistsException must be thrown if the node to be restored already exsits and removeExisting was set to false.");
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }

    public void testRestoreWithUUIDConflictJcr2() throws RepositoryException, NotExecutableException {
        try {
            Node naa = this.createVersionableNode(this.versionableNode, this.nodeName4, this.versionableNodeType);
            NodeDefinition nd = naa.getDefinition();
            if (nd.getOnParentVersion() != 1 && nd.getOnParentVersion() != 2) {
                throw new NotExecutableException("Child nodes must have OPV COPY or VERSION in order to be able to test Node.restore with uuid conflict.");
            }
            Version v = this.versionManager.checkin(this.versionableNode.getPath());
            this.versionManager.checkout(this.versionableNode.getPath());
            this.superuser.move(naa.getPath(), this.versionableNode2.getPath() + "/" + naa.getName());
            this.superuser.save();
            this.versionManager.restore(v, false);
            RestoreTest.fail((String)"Node.restore( Version, boolean ): An ItemExistsException must be thrown if the node to be restored already exsits and removeExisting was set to false.");
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }

    public void testRestoreWithUUIDConflictJcr2_2() throws RepositoryException, NotExecutableException {
        try {
            Node naa = this.createVersionableNode(this.versionableNode, this.nodeName4, this.versionableNodeType);
            NodeDefinition nd = naa.getDefinition();
            if (nd.getOnParentVersion() != 1 && nd.getOnParentVersion() != 2) {
                throw new NotExecutableException("Child nodes must have OPV COPY or VERSION in order to be able to test Node.restore with uuid conflict.");
            }
            Version v = this.versionManager.checkin(this.versionableNode.getPath());
            this.versionManager.checkout(this.versionableNode.getPath());
            this.superuser.move(naa.getPath(), this.versionableNode2.getPath() + "/" + naa.getName());
            this.superuser.save();
            this.versionManager.restore(v, false);
            RestoreTest.fail((String)"Node.restore( Version, boolean ): An ItemExistsException must be thrown if the node to be restored already exsits and removeExisting was set to false.");
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }

    public void testRestoreWithUUIDConflictJcr2_3() throws RepositoryException, NotExecutableException {
        try {
            Node naa = this.createVersionableNode(this.versionableNode, this.nodeName4, this.versionableNodeType);
            NodeDefinition nd = naa.getDefinition();
            if (nd.getOnParentVersion() != 1 && nd.getOnParentVersion() != 2) {
                throw new NotExecutableException("Child nodes must have OPV COPY or VERSION in order to be able to test Node.restore with uuid conflict.");
            }
            Version v = this.versionManager.checkin(this.versionableNode.getPath());
            this.versionManager.checkout(this.versionableNode.getPath());
            this.superuser.move(naa.getPath(), this.versionableNode2.getPath() + "/" + naa.getName());
            this.superuser.save();
            this.versionManager.restore(this.versionableNode.getPath(), v.getName(), false);
            RestoreTest.fail((String)"Node.restore( Version, boolean ): An ItemExistsException must be thrown if the node to be restored already exsits and removeExisting was set to false.");
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }

    public void testRestoreWithUUIDConflictJcr2_4() throws RepositoryException, NotExecutableException {
        try {
            Node naa = this.createVersionableNode(this.versionableNode, this.nodeName4, this.versionableNodeType);
            NodeDefinition nd = naa.getDefinition();
            if (nd.getOnParentVersion() != 1 && nd.getOnParentVersion() != 2) {
                throw new NotExecutableException("Child nodes must have OPV COPY or VERSION in order to be able to test Node.restore with uuid conflict.");
            }
            Version v = this.versionManager.checkin(this.versionableNode.getPath());
            this.versionManager.checkout(this.versionableNode.getPath());
            this.superuser.move(naa.getPath(), this.versionableNode2.getPath() + "/" + naa.getName());
            this.superuser.save();
            this.versionManager.restore(new Version[]{v}, false);
            RestoreTest.fail((String)"Node.restore( Version, boolean ): An ItemExistsException must be thrown if the node to be restored already exsits and removeExisting was set to false.");
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }

    public void testRestoreChild1() throws RepositoryException {
        this.versionableNode.addNode("child1");
        this.versionableNode.getSession().save();
        Version v1 = this.versionableNode.checkin();
        this.versionableNode.checkout();
        Version v2 = this.versionableNode.checkin();
        this.versionableNode.restore(v1, true);
        RestoreTest.assertTrue((String)"Node.restore('1.2') must not remove child node.", (boolean)this.versionableNode.hasNode("child1"));
        this.versionableNode.restore(this.version, true);
        RestoreTest.assertFalse((String)"Node.restore('1.0') must remove child node.", (boolean)this.versionableNode.hasNode("child1"));
        try {
            this.versionableNode.restore(v2, true);
        }
        catch (RepositoryException e) {
            RestoreTest.fail((String)"Node.restore('1.3') must fail.");
        }
    }

    public void testRestoreRemoved() throws RepositoryException {
        Node parent = this.versionableNode.getParent();
        String oldName = this.versionableNode.getName();
        Version v1 = this.versionableNode.checkin();
        this.versionableNode.remove();
        this.versionableNode = null;
        parent.getSession().save();
        parent.restore(v1, oldName, true);
        this.versionableNode = parent.getNode(oldName);
        String value = this.versionableNode.getProperty(this.propertyName1).getString();
        RestoreTest.assertEquals((String)"Restoring a node must set the correct property.", (String)this.propertyValue2, (String)value);
    }

    public void testRestoreRemovedJcr2() throws RepositoryException {
        String path = this.versionableNode.getPath();
        Version v1 = this.versionManager.checkin(path);
        this.versionableNode.remove();
        this.versionableNode = null;
        this.superuser.save();
        this.versionManager.restore(path, v1, true);
        this.versionableNode = this.superuser.getNode(path);
        String value = this.versionableNode.getProperty(this.propertyName1).getString();
        RestoreTest.assertEquals((String)"Restoring a node must set the correct property.", (String)this.propertyValue2, (String)value);
    }

    public void testRestoreChild1Jcr2() throws RepositoryException {
        this.versionableNode.addNode("child1");
        this.versionableNode.getSession().save();
        Version v1 = this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.checkout(this.versionableNode.getPath());
        Version v2 = this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.restore(v1, true);
        RestoreTest.assertTrue((String)"Node.restore('1.2') must not remove child node.", (boolean)this.versionableNode.hasNode("child1"));
        this.versionManager.restore(this.version, true);
        RestoreTest.assertFalse((String)"Node.restore('1.0') must remove child node.", (boolean)this.versionableNode.hasNode("child1"));
        try {
            this.versionManager.restore(v2, true);
        }
        catch (RepositoryException e) {
            RestoreTest.fail((String)"Node.restore('1.3') must fail.");
        }
    }

    public void testRestoreChild1Jcr2_2() throws RepositoryException {
        this.versionableNode.addNode("child1");
        this.versionableNode.getSession().save();
        Version v1 = this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.checkout(this.versionableNode.getPath());
        Version v2 = this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.restore(v1, true);
        RestoreTest.assertTrue((String)"Node.restore('1.2') must not remove child node.", (boolean)this.versionableNode.hasNode("child1"));
        this.versionManager.restore(this.version, true);
        RestoreTest.assertFalse((String)"Node.restore('1.0') must remove child node.", (boolean)this.versionableNode.hasNode("child1"));
        try {
            this.versionManager.restore(v2, true);
        }
        catch (RepositoryException e) {
            RestoreTest.fail((String)"Node.restore('1.3') must fail.");
        }
    }

    public void testRestoreChild1Jcr2_3() throws RepositoryException {
        this.versionableNode.addNode("child1");
        this.versionableNode.getSession().save();
        Version v1 = this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.checkout(this.versionableNode.getPath());
        Version v2 = this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.restore(this.versionableNode.getPath(), v1.getName(), true);
        RestoreTest.assertTrue((String)"Node.restore('1.2') must not remove child node.", (boolean)this.versionableNode.hasNode("child1"));
        this.versionManager.restore(this.versionableNode.getPath(), this.version.getName(), true);
        RestoreTest.assertFalse((String)"Node.restore('1.0') must remove child node.", (boolean)this.versionableNode.hasNode("child1"));
        try {
            this.versionManager.restore(this.versionableNode.getPath(), v2.getName(), true);
        }
        catch (RepositoryException e) {
            RestoreTest.fail((String)"Node.restore('1.3') must fail.");
        }
    }

    public void testRestoreChild1Jcr2_4() throws RepositoryException {
        this.versionableNode.addNode("child1");
        this.versionableNode.getSession().save();
        Version v1 = this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.checkout(this.versionableNode.getPath());
        Version v2 = this.versionManager.checkin(this.versionableNode.getPath());
        this.versionManager.restore(new Version[]{v1}, true);
        RestoreTest.assertTrue((String)"Node.restore('1.2') must not remove child node.", (boolean)this.versionableNode.hasNode("child1"));
        this.versionManager.restore(new Version[]{this.version}, true);
        RestoreTest.assertFalse((String)"Node.restore('1.0') must remove child node.", (boolean)this.versionableNode.hasNode("child1"));
        try {
            this.versionManager.restore(new Version[]{v2}, true);
        }
        catch (RepositoryException e) {
            RestoreTest.fail((String)"Node.restore('1.3') must fail.");
        }
    }

    public void testRestoreLabel() throws RepositoryException {
        this.versionableNode.getVersionHistory().addVersionLabel(this.version.getName(), "test", true);
        this.versionableNode.restoreByLabel("test", true);
        String value = this.versionableNode.getProperty(this.propertyName1).getString();
        RestoreTest.assertEquals((String)"Node.restore('test') not correctly restored", (String)this.propertyValue1, (String)value);
    }

    public void testRestoreLabelJcr2() throws RepositoryException {
        this.versionManager.getVersionHistory(this.versionableNode.getPath()).addVersionLabel(this.version.getName(), "test", true);
        this.versionManager.restoreByLabel(this.versionableNode.getPath(), "test", true);
        String value = this.versionableNode.getProperty(this.propertyName1).getString();
        RestoreTest.assertEquals((String)"Node.restore('test') not correctly restored", (String)this.propertyValue1, (String)value);
    }

    public void testRestoreName() throws RepositoryException, NotExecutableException {
        Node child1 = this.versionableNode.addNode(this.nodeName4);
        this.ensureMixinType(child1, this.mixVersionable);
        this.versionableNode.getSession().save();
        Version v1Child = child1.checkin();
        String v1 = this.versionableNode.checkin().getName();
        child1.checkout();
        child1.checkin();
        this.versionableNode.checkout();
        String v2 = this.versionableNode.checkin().getName();
        this.versionableNode.restore(this.version, true);
        RestoreTest.assertFalse((String)"Node.restore('1.0') must remove child node.", (boolean)this.versionableNode.hasNode(this.nodeName4));
        this.versionableNode.restore(v1, true);
        RestoreTest.assertTrue((String)"Node.restore('test') must restore child node.", (boolean)this.versionableNode.hasNode(this.nodeName4));
        child1 = this.versionableNode.getNode(this.nodeName4);
        RestoreTest.assertEquals((String)"Node.restore('test') must restore child node version 1.0.", (String)v1Child.getName(), (String)child1.getBaseVersion().getName());
        this.versionableNode.restore(v2, true);
        child1 = this.versionableNode.getNode(this.nodeName4);
        RestoreTest.assertEquals((String)"Node.restore('foo') must not restore child node and keep version 1.0.", (String)v1Child.getName(), (String)child1.getBaseVersion().getName());
    }

    public void testRestoreNameJcr2() throws RepositoryException, NotExecutableException {
        Node child1 = this.versionableNode.addNode(this.nodeName4);
        this.ensureMixinType(child1, this.mixVersionable);
        this.versionableNode.getSession().save();
        Version v1Child = this.versionManager.checkin(child1.getPath());
        String v1 = this.versionManager.checkin(this.versionableNode.getPath()).getName();
        this.versionManager.checkout(child1.getPath());
        this.versionManager.checkin(child1.getPath());
        this.versionManager.checkout(this.versionableNode.getPath());
        String v2 = this.versionManager.checkin(this.versionableNode.getPath()).getName();
        this.versionManager.restore(this.version, true);
        RestoreTest.assertFalse((String)"restore must remove child node.", (boolean)this.versionableNode.hasNode(this.nodeName4));
        this.versionManager.restore(this.versionableNode.getPath(), v1, true);
        RestoreTest.assertTrue((String)"restore must restore child node.", (boolean)this.versionableNode.hasNode(this.nodeName4));
        child1 = this.versionableNode.getNode(this.nodeName4);
        RestoreTest.assertEquals((String)"restore must restore child node version 1.0.", (String)v1Child.getName(), (String)this.versionManager.getBaseVersion(child1.getPath()).getName());
        this.versionManager.restore(this.versionableNode.getPath(), v2, true);
        child1 = this.versionableNode.getNode(this.nodeName4);
        RestoreTest.assertEquals((String)"Node.restore('foo') must not restore child node and keep version 1.0.", (String)v1Child.getName(), (String)this.versionManager.getBaseVersion(child1.getPath()).getName());
    }

    public void testRestoreOrder() throws RepositoryException, NotExecutableException {
        Node testRoot = this.versionableNode.addNode(this.nodeName4, "nt:unstructured");
        this.ensureMixinType(testRoot, this.mixVersionable);
        this.versionableNode.getSession().save();
        Node child1 = testRoot.addNode(this.nodeName1);
        this.ensureMixinType(child1, this.mixVersionable);
        Node child2 = testRoot.addNode(this.nodeName2);
        this.ensureMixinType(child2, this.mixVersionable);
        testRoot.getSession().save();
        child1.checkin();
        child2.checkin();
        Version v1 = testRoot.checkin();
        testRoot.checkout();
        child1.remove();
        testRoot.getSession().save();
        testRoot.checkin();
        testRoot.restore(v1, true);
        NodeIterator iter = testRoot.getNodes();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n1 = iter.nextNode();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n2 = iter.nextNode();
        String orderOk = this.nodeName1 + ", " + this.nodeName2;
        String order = n1.getName() + ", " + n2.getName();
        RestoreTest.assertEquals((String)"Invalid child node ordering", (String)orderOk, (String)order);
    }

    public void testRestoreOrderJcr2() throws RepositoryException, NotExecutableException {
        Node testRoot = this.versionableNode.addNode(this.nodeName4, "nt:unstructured");
        this.ensureMixinType(testRoot, this.mixVersionable);
        this.versionableNode.getSession().save();
        Node child1 = testRoot.addNode(this.nodeName1);
        this.ensureMixinType(child1, this.mixVersionable);
        Node child2 = testRoot.addNode(this.nodeName2);
        this.ensureMixinType(child2, this.mixVersionable);
        testRoot.getSession().save();
        this.versionManager.checkin(child1.getPath());
        this.versionManager.checkin(child2.getPath());
        Version v1 = this.versionManager.checkin(testRoot.getPath());
        this.versionManager.checkout(testRoot.getPath());
        child1.remove();
        testRoot.getSession().save();
        this.versionManager.checkout(testRoot.getPath());
        this.versionManager.restore(v1, true);
        NodeIterator iter = testRoot.getNodes();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n1 = iter.nextNode();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n2 = iter.nextNode();
        String orderOk = this.nodeName1 + ", " + this.nodeName2;
        String order = n1.getName() + ", " + n2.getName();
        RestoreTest.assertEquals((String)"Invalid child node ordering", (String)orderOk, (String)order);
    }

    public void testRestoreOrderJcr2_2() throws RepositoryException, NotExecutableException {
        Node testRoot = this.versionableNode.addNode(this.nodeName4, "nt:unstructured");
        this.ensureMixinType(testRoot, this.mixVersionable);
        this.versionableNode.getSession().save();
        Node child1 = testRoot.addNode(this.nodeName1);
        this.ensureMixinType(child1, this.mixVersionable);
        Node child2 = testRoot.addNode(this.nodeName2);
        this.ensureMixinType(child2, this.mixVersionable);
        testRoot.getSession().save();
        this.versionManager.checkin(child1.getPath());
        this.versionManager.checkin(child2.getPath());
        Version v1 = this.versionManager.checkin(testRoot.getPath());
        this.versionManager.checkout(testRoot.getPath());
        child1.remove();
        testRoot.getSession().save();
        this.versionManager.checkout(testRoot.getPath());
        this.versionManager.restore(v1, true);
        NodeIterator iter = testRoot.getNodes();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n1 = iter.nextNode();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n2 = iter.nextNode();
        String orderOk = this.nodeName1 + ", " + this.nodeName2;
        String order = n1.getName() + ", " + n2.getName();
        RestoreTest.assertEquals((String)"Invalid child node ordering", (String)orderOk, (String)order);
    }

    public void testRestoreOrderJcr2_3() throws RepositoryException, NotExecutableException {
        Node testRoot = this.versionableNode.addNode(this.nodeName4, "nt:unstructured");
        this.ensureMixinType(testRoot, this.mixVersionable);
        this.versionableNode.getSession().save();
        Node child1 = testRoot.addNode(this.nodeName1);
        this.ensureMixinType(child1, this.mixVersionable);
        Node child2 = testRoot.addNode(this.nodeName2);
        this.ensureMixinType(child2, this.mixVersionable);
        testRoot.getSession().save();
        this.versionManager.checkin(child1.getPath());
        this.versionManager.checkin(child2.getPath());
        Version v1 = this.versionManager.checkin(testRoot.getPath());
        this.versionManager.checkout(testRoot.getPath());
        child1.remove();
        testRoot.getSession().save();
        this.versionManager.checkout(testRoot.getPath());
        this.versionManager.restore(testRoot.getPath(), v1.getName(), true);
        NodeIterator iter = testRoot.getNodes();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n1 = iter.nextNode();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n2 = iter.nextNode();
        String orderOk = this.nodeName1 + ", " + this.nodeName2;
        String order = n1.getName() + ", " + n2.getName();
        RestoreTest.assertEquals((String)"Invalid child node ordering", (String)orderOk, (String)order);
    }

    public void testRestoreOrderJcr2_4() throws RepositoryException, NotExecutableException {
        Node testRoot = this.versionableNode.addNode(this.nodeName4, "nt:unstructured");
        this.ensureMixinType(testRoot, this.mixVersionable);
        this.versionableNode.getSession().save();
        Node child1 = testRoot.addNode(this.nodeName1);
        this.ensureMixinType(child1, this.mixVersionable);
        Node child2 = testRoot.addNode(this.nodeName2);
        this.ensureMixinType(child2, this.mixVersionable);
        testRoot.getSession().save();
        this.versionManager.checkin(child1.getPath());
        this.versionManager.checkin(child2.getPath());
        Version v1 = this.versionManager.checkin(testRoot.getPath());
        this.versionManager.checkout(testRoot.getPath());
        child1.remove();
        testRoot.getSession().save();
        this.versionManager.checkout(testRoot.getPath());
        this.versionManager.restore(new Version[]{v1}, true);
        NodeIterator iter = testRoot.getNodes();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n1 = iter.nextNode();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n2 = iter.nextNode();
        String orderOk = this.nodeName1 + ", " + this.nodeName2;
        String order = n1.getName() + ", " + n2.getName();
        RestoreTest.assertEquals((String)"Invalid child node ordering", (String)orderOk, (String)order);
    }

    public void testRestoreOrder2() throws RepositoryException, NotExecutableException {
        Node testRoot = this.versionableNode.addNode(this.nodeName4, "nt:unstructured");
        this.ensureMixinType(testRoot, this.mixVersionable);
        this.versionableNode.getSession().save();
        Node child1 = testRoot.addNode(this.nodeName1);
        this.ensureMixinType(child1, this.mixVersionable);
        Node child2 = testRoot.addNode(this.nodeName2);
        this.ensureMixinType(child2, this.mixVersionable);
        testRoot.getSession().save();
        child1.checkin();
        child2.checkin();
        Version v1 = testRoot.checkin();
        testRoot.checkout();
        testRoot.orderBefore(this.nodeName2, this.nodeName1);
        testRoot.getSession().save();
        testRoot.checkin();
        testRoot.restore(v1, true);
        NodeIterator iter = testRoot.getNodes();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n1 = iter.nextNode();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n2 = iter.nextNode();
        String orderOk = this.nodeName1 + ", " + this.nodeName2;
        String order = n1.getName() + ", " + n2.getName();
        RestoreTest.assertEquals((String)"Invalid child node ordering", (String)orderOk, (String)order);
    }

    public void testRestoreOrder2Jcr2() throws RepositoryException, NotExecutableException {
        Node testRoot = this.versionableNode.addNode(this.nodeName4, "nt:unstructured");
        this.ensureMixinType(testRoot, this.mixVersionable);
        this.versionableNode.getSession().save();
        Node child1 = testRoot.addNode(this.nodeName1);
        this.ensureMixinType(child1, this.mixVersionable);
        Node child2 = testRoot.addNode(this.nodeName2);
        this.ensureMixinType(child2, this.mixVersionable);
        testRoot.getSession().save();
        this.versionManager.checkin(child1.getPath());
        this.versionManager.checkin(child2.getPath());
        Version v1 = this.versionManager.checkin(testRoot.getPath());
        this.versionManager.checkout(testRoot.getPath());
        testRoot.orderBefore(this.nodeName2, this.nodeName1);
        testRoot.getSession().save();
        this.versionManager.checkin(testRoot.getPath());
        this.versionManager.restore(v1, true);
        NodeIterator iter = testRoot.getNodes();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n1 = iter.nextNode();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n2 = iter.nextNode();
        String orderOk = this.nodeName1 + ", " + this.nodeName2;
        String order = n1.getName() + ", " + n2.getName();
        RestoreTest.assertEquals((String)"Invalid child node ordering", (String)orderOk, (String)order);
    }

    public void testRestoreOrder2Jcr2_2() throws RepositoryException, NotExecutableException {
        Node testRoot = this.versionableNode.addNode(this.nodeName4, "nt:unstructured");
        this.ensureMixinType(testRoot, this.mixVersionable);
        this.versionableNode.getSession().save();
        Node child1 = testRoot.addNode(this.nodeName1);
        this.ensureMixinType(child1, this.mixVersionable);
        Node child2 = testRoot.addNode(this.nodeName2);
        this.ensureMixinType(child2, this.mixVersionable);
        testRoot.getSession().save();
        this.versionManager.checkin(child1.getPath());
        this.versionManager.checkin(child2.getPath());
        Version v1 = this.versionManager.checkin(testRoot.getPath());
        this.versionManager.checkout(testRoot.getPath());
        testRoot.orderBefore(this.nodeName2, this.nodeName1);
        testRoot.getSession().save();
        this.versionManager.checkin(testRoot.getPath());
        this.versionManager.restore(v1, true);
        NodeIterator iter = testRoot.getNodes();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n1 = iter.nextNode();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n2 = iter.nextNode();
        String orderOk = this.nodeName1 + ", " + this.nodeName2;
        String order = n1.getName() + ", " + n2.getName();
        RestoreTest.assertEquals((String)"Invalid child node ordering", (String)orderOk, (String)order);
    }

    public void testRestoreOrder2Jcr2_3() throws RepositoryException, NotExecutableException {
        Node testRoot = this.versionableNode.addNode(this.nodeName4, "nt:unstructured");
        this.ensureMixinType(testRoot, this.mixVersionable);
        this.versionableNode.getSession().save();
        Node child1 = testRoot.addNode(this.nodeName1);
        this.ensureMixinType(child1, this.mixVersionable);
        Node child2 = testRoot.addNode(this.nodeName2);
        this.ensureMixinType(child2, this.mixVersionable);
        testRoot.getSession().save();
        this.versionManager.checkin(child1.getPath());
        this.versionManager.checkin(child2.getPath());
        Version v1 = this.versionManager.checkin(testRoot.getPath());
        this.versionManager.checkout(testRoot.getPath());
        testRoot.orderBefore(this.nodeName2, this.nodeName1);
        testRoot.getSession().save();
        this.versionManager.checkin(testRoot.getPath());
        this.versionManager.restore(v1, true);
        NodeIterator iter = testRoot.getNodes();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n1 = iter.nextNode();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n2 = iter.nextNode();
        String orderOk = this.nodeName1 + ", " + this.nodeName2;
        String order = n1.getName() + ", " + n2.getName();
        RestoreTest.assertEquals((String)"Invalid child node ordering", (String)orderOk, (String)order);
    }

    public void testRestoreOrder2Jcr2_4() throws RepositoryException, NotExecutableException {
        Node testRoot = this.versionableNode.addNode(this.nodeName4, "nt:unstructured");
        this.ensureMixinType(testRoot, this.mixVersionable);
        this.versionableNode.getSession().save();
        Node child1 = testRoot.addNode(this.nodeName1);
        this.ensureMixinType(child1, this.mixVersionable);
        Node child2 = testRoot.addNode(this.nodeName2);
        this.ensureMixinType(child2, this.mixVersionable);
        testRoot.getSession().save();
        this.versionManager.checkin(child1.getPath());
        this.versionManager.checkin(child2.getPath());
        Version v1 = this.versionManager.checkin(testRoot.getPath());
        this.versionManager.checkout(testRoot.getPath());
        testRoot.orderBefore(this.nodeName2, this.nodeName1);
        testRoot.getSession().save();
        this.versionManager.checkin(testRoot.getPath());
        this.versionManager.restore(new Version[]{v1}, true);
        NodeIterator iter = testRoot.getNodes();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n1 = iter.nextNode();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n2 = iter.nextNode();
        String orderOk = this.nodeName1 + ", " + this.nodeName2;
        String order = n1.getName() + ", " + n2.getName();
        RestoreTest.assertEquals((String)"Invalid child node ordering", (String)orderOk, (String)order);
    }
}

