/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import junit.framework.TestCase;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.jcr2spi.AbstractRepositoryConfig;
import org.apache.jackrabbit.jcr2spi.ItemInfoStore;
import org.apache.jackrabbit.jcr2spi.RepositoryImpl;
import org.apache.jackrabbit.jcr2spi.config.RepositoryConfig;
import org.apache.jackrabbit.spi.Batch;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.ItemInfoCache;
import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.Subscription;
import org.apache.jackrabbit.spi.Tree;
import org.apache.jackrabbit.spi.commons.AbstractReadableRepositoryService;
import org.apache.jackrabbit.spi.commons.ItemInfoBuilder;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;

public abstract class AbstractJCR2SPITest
extends TestCase
implements RepositoryService {
    private static final String DEFAULT_WSP = "default";
    private RepositoryService repositoryService;
    protected ItemInfoStore itemInfoStore;
    protected RepositoryConfig config;
    protected Repository repository;

    public void setUp() throws Exception {
        super.setUp();
        this.itemInfoStore = new ItemInfoStore();
        ItemInfoBuilder.Listener listener = new ItemInfoBuilder.Listener(){

            public void createPropertyInfo(PropertyInfo propertyInfo) {
                AbstractJCR2SPITest.this.itemInfoStore.addItemInfo((ItemInfo)propertyInfo);
            }

            public void createNodeInfo(NodeInfo nodeInfo) {
                AbstractJCR2SPITest.this.itemInfoStore.addItemInfo((ItemInfo)nodeInfo);
            }

            public void createChildInfos(NodeId id, Iterator<ChildInfo> childInfos) {
                AbstractJCR2SPITest.this.itemInfoStore.setChildInfos(id, childInfos);
            }
        };
        this.initInfosStore(ItemInfoBuilder.nodeInfoBuilder((ItemInfoBuilder.Listener)listener));
        this.repositoryService = this.getRepositoryService();
        this.config = this.getRepositoryConfig();
        this.repository = this.getRepository();
    }

    public static final String toJCRPath(Path path) {
        Path.Element[] elems = path.getElements();
        StringBuffer jcrPath = new StringBuffer();
        for (int k = 0; k < elems.length; ++k) {
            jcrPath.append(elems[k].getName().getLocalName());
            if (k + 1 >= elems.length && elems.length != 1) continue;
            jcrPath.append('/');
        }
        return jcrPath.toString();
    }

    protected abstract void initInfosStore(ItemInfoBuilder.NodeInfoBuilder var1) throws RepositoryException;

    protected RepositoryService getRepositoryService() throws RepositoryException, ParseException {
        return new AbstractReadableRepositoryService(this.getDescriptors(), this.getNameSpaces(), this.getCndReader(), this.getWspNames(), DEFAULT_WSP){

            protected void checkCredentials(Credentials credentials, String workspaceName) throws LoginException {
                AbstractJCR2SPITest.this.checkCredentials(credentials, workspaceName);
            }

            protected QNodeDefinition createRootNodeDefinition(SessionInfo sessionInfo) throws RepositoryException {
                return AbstractJCR2SPITest.this.createRootNodeDefinition();
            }

            public Iterator<? extends ItemInfo> getItemInfos(SessionInfo sessionInfo, ItemId itemId) throws ItemNotFoundException, RepositoryException {
                return AbstractJCR2SPITest.this.getItemInfos(sessionInfo, itemId);
            }

            public Iterator<ChildInfo> getChildInfos(SessionInfo sessionInfo, NodeId parentId) throws ItemNotFoundException, RepositoryException {
                return AbstractJCR2SPITest.this.getChildInfos(sessionInfo, parentId);
            }

            public PrivilegeDefinition[] getPrivilegeDefinitions(SessionInfo sessionInfo) throws RepositoryException {
                return AbstractJCR2SPITest.this.getPrivilegeDefinitions(sessionInfo);
            }

            public PrivilegeDefinition[] getSupportedPrivileges(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
                return AbstractJCR2SPITest.this.getSupportedPrivileges(sessionInfo, nodeId);
            }

            public Name[] getPrivilegeNames(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
                return AbstractJCR2SPITest.this.getPrivilegeNames(sessionInfo, nodeId);
            }

            public NodeInfo getNodeInfo(SessionInfo sessionInfo, NodeId nodeId) throws ItemNotFoundException, RepositoryException {
                return AbstractJCR2SPITest.this.getNodeInfo(sessionInfo, nodeId);
            }

            public PropertyInfo getPropertyInfo(SessionInfo sessionInfo, PropertyId propertyId) throws ItemNotFoundException, RepositoryException {
                return AbstractJCR2SPITest.this.getPropertyInfo(sessionInfo, propertyId);
            }

            public Iterator<PropertyId> getReferences(SessionInfo sessionInfo, NodeId nodeId, Name propertyName, boolean weakReferences) throws ItemNotFoundException, RepositoryException {
                return AbstractJCR2SPITest.this.getReferences(sessionInfo, nodeId, propertyName, weakReferences);
            }
        };
    }

    protected Reader getCndReader() throws RepositoryException {
        String resourceName = "default-nodetypes.cnd";
        InputStream is = AbstractJCR2SPITest.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new RepositoryException("Resource not found: " + resourceName);
        }
        return new InputStreamReader(new BufferedInputStream(is));
    }

    protected Map<String, String> getNameSpaces() {
        return Collections.emptyMap();
    }

    protected Map<String, QValue[]> getDescriptors() throws RepositoryException {
        HashMap<String, QValue[]> descriptorKeys = new HashMap<String, QValue[]>();
        QValueFactory qvf = QValueFactoryImpl.getInstance();
        descriptorKeys.put("jcr.repository.name", new QValue[]{qvf.create("Mock Repository", 1)});
        descriptorKeys.put("jcr.repository.vendor", new QValue[]{qvf.create("Apache Software Foundation", 1)});
        descriptorKeys.put("jcr.repository.vendor.url", new QValue[]{qvf.create("http://www.apache.org/", 1)});
        descriptorKeys.put("jcr.repository.version", new QValue[]{qvf.create("2.0", 1)});
        descriptorKeys.put("jcr.specification.name", new QValue[]{qvf.create("Content Repository API for Java(TM) Technology Specification", 1)});
        descriptorKeys.put("jcr.specification.version", new QValue[]{qvf.create("2.0", 1)});
        return descriptorKeys;
    }

    protected List<String> getWspNames() {
        return Collections.singletonList(DEFAULT_WSP);
    }

    protected RepositoryConfig getRepositoryConfig() {
        return new AbstractRepositoryConfig(){

            public RepositoryService getRepositoryService() throws RepositoryException {
                return AbstractJCR2SPITest.this;
            }
        };
    }

    protected Repository getRepository() throws RepositoryException {
        return RepositoryImpl.create((RepositoryConfig)this.config);
    }

    protected void checkCredentials(Credentials credentials, String workspaceName) {
    }

    public IdFactory getIdFactory() throws RepositoryException {
        return this.repositoryService.getIdFactory();
    }

    public NameFactory getNameFactory() throws RepositoryException {
        return this.repositoryService.getNameFactory();
    }

    public PathFactory getPathFactory() throws RepositoryException {
        return this.repositoryService.getPathFactory();
    }

    public QValueFactory getQValueFactory() throws RepositoryException {
        return this.repositoryService.getQValueFactory();
    }

    public Map<String, QValue[]> getRepositoryDescriptors() throws RepositoryException {
        return this.repositoryService.getRepositoryDescriptors();
    }

    public ItemInfoCache getItemInfoCache(SessionInfo sessionInfo) throws RepositoryException {
        return this.repositoryService.getItemInfoCache(sessionInfo);
    }

    public PrivilegeDefinition[] getPrivilegeDefinitions(SessionInfo sessionInfo) throws RepositoryException {
        return this.repositoryService.getPrivilegeDefinitions(sessionInfo);
    }

    public PrivilegeDefinition[] getSupportedPrivileges(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        return this.repositoryService.getSupportedPrivileges(sessionInfo, nodeId);
    }

    public Name[] getPrivilegeNames(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        return this.repositoryService.getPrivilegeNames(sessionInfo, nodeId);
    }

    public SessionInfo obtain(Credentials credentials, String workspaceName) throws RepositoryException {
        return this.repositoryService.obtain(credentials, workspaceName);
    }

    public SessionInfo obtain(SessionInfo sessionInfo, String workspaceName) throws RepositoryException {
        return this.repositoryService.obtain(sessionInfo, workspaceName);
    }

    public SessionInfo impersonate(SessionInfo sessionInfo, Credentials credentials) throws RepositoryException {
        return this.repositoryService.impersonate(sessionInfo, credentials);
    }

    public void dispose(SessionInfo sessionInfo) throws RepositoryException {
        this.repositoryService.dispose(sessionInfo);
    }

    public String[] getWorkspaceNames(SessionInfo sessionInfo) throws RepositoryException {
        return this.repositoryService.getWorkspaceNames(sessionInfo);
    }

    public boolean isGranted(SessionInfo sessionInfo, ItemId itemId, String[] actions) throws RepositoryException {
        return this.repositoryService.isGranted(sessionInfo, itemId, actions);
    }

    public QNodeDefinition getNodeDefinition(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        return this.repositoryService.getNodeDefinition(sessionInfo, nodeId);
    }

    public QPropertyDefinition getPropertyDefinition(SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        return this.repositoryService.getPropertyDefinition(sessionInfo, propertyId);
    }

    protected abstract QNodeDefinition createRootNodeDefinition();

    public abstract NodeInfo getNodeInfo(SessionInfo var1, NodeId var2) throws RepositoryException;

    public abstract Iterator<? extends ItemInfo> getItemInfos(SessionInfo var1, ItemId var2) throws ItemNotFoundException, RepositoryException;

    public abstract Iterator<ChildInfo> getChildInfos(SessionInfo var1, NodeId var2) throws ItemNotFoundException, RepositoryException;

    public abstract PropertyInfo getPropertyInfo(SessionInfo var1, PropertyId var2) throws ItemNotFoundException, RepositoryException;

    public Iterator<PropertyId> getReferences(SessionInfo sessionInfo, NodeId nodeId, Name propertyName, boolean weakReferences) throws RepositoryException {
        return this.repositoryService.getReferences(sessionInfo, nodeId, propertyName, weakReferences);
    }

    public Batch createBatch(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        return this.repositoryService.createBatch(sessionInfo, itemId);
    }

    public void submit(Batch batch) throws RepositoryException {
        this.repositoryService.submit(batch);
    }

    public Tree createTree(SessionInfo sessionInfo, Batch batch, Name nodeName, Name primaryTypeName, String uniqueId) throws RepositoryException {
        return this.repositoryService.createTree(sessionInfo, batch, nodeName, primaryTypeName, uniqueId);
    }

    public void importXml(SessionInfo sessionInfo, NodeId parentId, InputStream xmlStream, int uuidBehaviour) throws RepositoryException {
        this.repositoryService.importXml(sessionInfo, parentId, xmlStream, uuidBehaviour);
    }

    public void move(SessionInfo sessionInfo, NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
        this.repositoryService.move(sessionInfo, srcNodeId, destParentNodeId, destName);
    }

    public void copy(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
        this.repositoryService.copy(sessionInfo, srcWorkspaceName, srcNodeId, destParentNodeId, destName);
    }

    public void update(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName) throws RepositoryException {
        this.repositoryService.update(sessionInfo, nodeId, srcWorkspaceName);
    }

    public void clone(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName, boolean removeExisting) throws RepositoryException {
        this.repositoryService.clone(sessionInfo, srcWorkspaceName, srcNodeId, destParentNodeId, destName, removeExisting);
    }

    public LockInfo getLockInfo(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        return this.repositoryService.getLockInfo(sessionInfo, nodeId);
    }

    public LockInfo lock(SessionInfo sessionInfo, NodeId nodeId, boolean deep, boolean sessionScoped) throws RepositoryException {
        return this.repositoryService.lock(sessionInfo, nodeId, deep, sessionScoped);
    }

    public LockInfo lock(SessionInfo sessionInfo, NodeId nodeId, boolean deep, boolean sessionScoped, long timeoutHint, String ownerHint) throws RepositoryException {
        return this.repositoryService.lock(sessionInfo, nodeId, deep, sessionScoped, timeoutHint, ownerHint);
    }

    public void refreshLock(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        this.repositoryService.refreshLock(sessionInfo, nodeId);
    }

    public void unlock(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        this.repositoryService.unlock(sessionInfo, nodeId);
    }

    public NodeId checkin(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        return this.repositoryService.checkin(sessionInfo, nodeId);
    }

    public void checkout(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        this.repositoryService.checkout(sessionInfo, nodeId);
    }

    public void checkout(SessionInfo sessionInfo, NodeId nodeId, NodeId activityId) throws RepositoryException {
        this.repositoryService.checkout(sessionInfo, nodeId, activityId);
    }

    public NodeId checkpoint(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        return this.repositoryService.checkpoint(sessionInfo, nodeId);
    }

    public NodeId checkpoint(SessionInfo sessionInfo, NodeId nodeId, NodeId activityId) throws RepositoryException {
        return this.repositoryService.checkpoint(sessionInfo, nodeId, activityId);
    }

    public void removeVersion(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId) throws RepositoryException {
        this.repositoryService.removeVersion(sessionInfo, versionHistoryId, versionId);
    }

    public void restore(SessionInfo sessionInfo, NodeId[] versionIds, boolean removeExisting) throws RepositoryException {
        this.repositoryService.restore(sessionInfo, versionIds, removeExisting);
    }

    public void restore(SessionInfo sessionInfo, NodeId nodeId, NodeId versionId, boolean removeExisting) throws RepositoryException {
        this.repositoryService.restore(sessionInfo, nodeId, versionId, removeExisting);
    }

    public Iterator<NodeId> merge(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName, boolean bestEffort) throws RepositoryException {
        return this.repositoryService.merge(sessionInfo, nodeId, srcWorkspaceName, bestEffort);
    }

    public Iterator<NodeId> merge(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName, boolean bestEffort, boolean isShallow) throws RepositoryException {
        return this.repositoryService.merge(sessionInfo, nodeId, srcWorkspaceName, bestEffort, isShallow);
    }

    public void resolveMergeConflict(SessionInfo sessionInfo, NodeId nodeId, NodeId[] mergeFailedIds, NodeId[] predecessorIds) throws RepositoryException {
        this.repositoryService.resolveMergeConflict(sessionInfo, nodeId, mergeFailedIds, predecessorIds);
    }

    public void addVersionLabel(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId, Name label, boolean moveLabel) throws RepositoryException {
        this.repositoryService.addVersionLabel(sessionInfo, versionHistoryId, versionId, label, moveLabel);
    }

    public void removeVersionLabel(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId, Name label) throws RepositoryException {
        this.repositoryService.removeVersionLabel(sessionInfo, versionHistoryId, versionId, label);
    }

    public NodeId createActivity(SessionInfo sessionInfo, String title) throws RepositoryException {
        return this.repositoryService.createActivity(sessionInfo, title);
    }

    public void removeActivity(SessionInfo sessionInfo, NodeId activityId) throws RepositoryException {
        this.repositoryService.removeActivity(sessionInfo, activityId);
    }

    public Iterator<NodeId> mergeActivity(SessionInfo sessionInfo, NodeId activityId) throws RepositoryException {
        return this.repositoryService.mergeActivity(sessionInfo, activityId);
    }

    public NodeId createConfiguration(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        return this.repositoryService.createConfiguration(sessionInfo, nodeId);
    }

    public String[] getSupportedQueryLanguages(SessionInfo sessionInfo) throws RepositoryException {
        return this.repositoryService.getSupportedQueryLanguages(sessionInfo);
    }

    public String[] checkQueryStatement(SessionInfo sessionInfo, String statement, String language, Map<String, String> namespaces) throws RepositoryException {
        return this.repositoryService.checkQueryStatement(sessionInfo, statement, language, namespaces);
    }

    public QueryInfo executeQuery(SessionInfo sessionInfo, String statement, String language, Map<String, String> namespaces, long limit, long offset, Map<String, QValue> values) throws RepositoryException {
        return this.repositoryService.executeQuery(sessionInfo, statement, language, namespaces, limit, offset, values);
    }

    public EventFilter createEventFilter(SessionInfo sessionInfo, int eventTypes, Path absPath, boolean isDeep, String[] uuid, Name[] nodeTypeName, boolean noLocal) throws RepositoryException {
        return this.repositoryService.createEventFilter(sessionInfo, eventTypes, absPath, isDeep, uuid, nodeTypeName, noLocal);
    }

    public Subscription createSubscription(SessionInfo sessionInfo, EventFilter[] filters) throws RepositoryException {
        return this.repositoryService.createSubscription(sessionInfo, filters);
    }

    public void updateEventFilters(Subscription subscription, EventFilter[] filters) throws RepositoryException {
        this.repositoryService.updateEventFilters(subscription, filters);
    }

    public EventBundle[] getEvents(Subscription subscription, long timeout) throws RepositoryException, InterruptedException {
        return this.repositoryService.getEvents(subscription, timeout);
    }

    public EventBundle getEvents(SessionInfo sessionInfo, EventFilter filter, long after) throws RepositoryException {
        return this.repositoryService.getEvents(sessionInfo, filter, after);
    }

    public void dispose(Subscription subscription) throws RepositoryException {
        this.repositoryService.dispose(subscription);
    }

    public Map<String, String> getRegisteredNamespaces(SessionInfo sessionInfo) throws RepositoryException {
        return this.repositoryService.getRegisteredNamespaces(sessionInfo);
    }

    public String getNamespaceURI(SessionInfo sessionInfo, String prefix) throws RepositoryException {
        return this.repositoryService.getNamespaceURI(sessionInfo, prefix);
    }

    public String getNamespacePrefix(SessionInfo sessionInfo, String uri) throws RepositoryException {
        return this.repositoryService.getNamespacePrefix(sessionInfo, uri);
    }

    public void registerNamespace(SessionInfo sessionInfo, String prefix, String uri) throws RepositoryException {
        this.repositoryService.registerNamespace(sessionInfo, prefix, uri);
    }

    public void unregisterNamespace(SessionInfo sessionInfo, String uri) throws RepositoryException {
        this.repositoryService.unregisterNamespace(sessionInfo, uri);
    }

    public Iterator<QNodeTypeDefinition> getQNodeTypeDefinitions(SessionInfo sessionInfo) throws RepositoryException {
        return this.repositoryService.getQNodeTypeDefinitions(sessionInfo);
    }

    public Iterator<QNodeTypeDefinition> getQNodeTypeDefinitions(SessionInfo sessionInfo, Name[] nodeTypeNames) throws RepositoryException {
        return this.repositoryService.getQNodeTypeDefinitions(sessionInfo, nodeTypeNames);
    }

    public void registerNodeTypes(SessionInfo sessionInfo, QNodeTypeDefinition[] nodeTypeDefinitions, boolean allowUpdate) throws RepositoryException {
        this.repositoryService.registerNodeTypes(sessionInfo, nodeTypeDefinitions, allowUpdate);
    }

    public void unregisterNodeTypes(SessionInfo sessionInfo, Name[] nodeTypeNames) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
        this.repositoryService.unregisterNodeTypes(sessionInfo, nodeTypeNames);
    }

    public void createWorkspace(SessionInfo sessionInfo, String name, String srcWorkspaceName) throws RepositoryException {
        this.repositoryService.createWorkspace(sessionInfo, name, srcWorkspaceName);
    }

    public void deleteWorkspace(SessionInfo sessionInfo, String name) throws RepositoryException {
        this.repositoryService.deleteWorkspace(sessionInfo, name);
    }
}

