/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMoveTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(AbstractMoveTest.class);
    protected Node srcParentNode;
    protected Node destParentNode;
    protected Node moveNode;
    protected String destinationPath;

    AbstractMoveTest() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.srcParentNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.moveNode = this.srcParentNode.addNode(this.nodeName2, this.testNodeType);
        this.destParentNode = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        this.destinationPath = this.destParentNode.getPath() + "/" + this.nodeName2;
    }

    protected void tearDown() throws Exception {
        this.srcParentNode = null;
        this.destParentNode = null;
        this.moveNode = null;
        super.tearDown();
    }

    protected abstract boolean isSessionMove();

    protected void doMove(String srcPath, String destPath) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        if (this.isSessionMove()) {
            this.superuser.move(srcPath, destPath);
        } else {
            this.superuser.getWorkspace().move(srcPath, destPath);
        }
    }
}

