/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMoveTreeTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(AbstractMoveTreeTest.class);
    protected Node childNode;
    protected Node grandChildNode;
    protected Property childProperty;
    protected Node srcParentNode;
    protected Node destParentNode;
    protected String srcPath;
    protected String destinationPath;
    protected List<String> childPaths = new ArrayList<String>();

    AbstractMoveTreeTest() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.srcParentNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node moveNode = this.srcParentNode.addNode(this.nodeName2, this.testNodeType);
        this.destParentNode = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.srcPath = moveNode.getPath();
        this.destinationPath = this.destParentNode.getPath() + "/" + this.nodeName4;
        this.childProperty = moveNode.setProperty(this.propertyName2, "anyString");
        this.childNode = moveNode.addNode(this.nodeName2, this.testNodeType);
        this.grandChildNode = this.childNode.addNode(this.nodeName3, this.testNodeType);
        this.childPaths.add(this.grandChildNode.getPath());
        this.childPaths.add(this.childNode.getPath());
        this.doMove(moveNode.getPath(), this.destinationPath);
    }

    protected void tearDown() throws Exception {
        this.childNode = null;
        this.grandChildNode = null;
        this.childProperty = null;
        this.srcParentNode = null;
        this.destParentNode = null;
        super.tearDown();
    }

    protected abstract boolean saveBeforeMove();

    protected abstract boolean isSessionMove();

    protected void doMove(String srcPath, String destPath) throws RepositoryException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        if (this.saveBeforeMove()) {
            this.testRootNode.save();
        }
        if (this.isSessionMove()) {
            this.superuser.move(srcPath, destPath);
        } else {
            this.superuser.getWorkspace().move(srcPath, destPath);
        }
    }
}

