/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class AccessByRelativePathTest
extends AbstractJCRTest {
    private static String DOT = ".";
    private static String DOTDOT = "..";

    public void testRootHasNodeDot() throws RepositoryException {
        Node root = this.superuser.getRootNode();
        AccessByRelativePathTest.assertTrue((String)"Node.hasNode(\".\") must return true.", (boolean)root.hasNode(DOT));
    }

    public void testRootGetNodeDot() throws RepositoryException {
        Node root = this.superuser.getRootNode();
        AccessByRelativePathTest.assertTrue((String)"Node.getNode(\".\") must return the same node", (boolean)root.getNode(DOT).isSame((Item)root));
    }

    public void testRootGetNodeDotDot() throws RepositoryException {
        Node root = this.superuser.getRootNode();
        try {
            root.getNode(DOTDOT);
            AccessByRelativePathTest.fail((String)"Root does not have a parent node. <root>.getNode(\"..\") must fail.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testHasNodeDot() throws RepositoryException {
        AccessByRelativePathTest.assertTrue((String)"Node.hasNode(\".\") must return true.", (boolean)this.testRootNode.hasNode(DOT));
    }

    public void GetNodeDot() throws RepositoryException {
        AccessByRelativePathTest.assertTrue((String)"Node.getNode(\".\") must return the same node.", (boolean)this.testRootNode.getNode(DOT).isSame((Item)this.testRootNode));
    }

    public void testGetNodeDotDot() throws RepositoryException, NotExecutableException {
        Node parent;
        try {
            parent = this.testRootNode.getParent();
        }
        catch (Exception e) {
            throw new NotExecutableException();
        }
        AccessByRelativePathTest.assertTrue((String)"Node.getNode(\"..\") must return the parent.", (boolean)this.testRootNode.getNode(DOTDOT).isSame((Item)parent));
    }

    public void testHasPropertyDot() throws RepositoryException {
        AccessByRelativePathTest.assertFalse((String)"Node.hasProperty(\".\") must return false.", (boolean)this.testRootNode.hasProperty(DOT));
    }

    public void testGetPropertyDot() throws RepositoryException {
        try {
            this.testRootNode.getProperty(DOT);
            AccessByRelativePathTest.fail((String)"A node must never have a property \".\".");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testHasPropertyDotDot() throws RepositoryException {
        AccessByRelativePathTest.assertFalse((String)"Node.hasProperty(\"..\") must return false.", (boolean)this.testRootNode.hasProperty(DOTDOT));
    }

    public void testGetPropertyDotDot() throws RepositoryException {
        try {
            this.testRootNode.getProperty(DOTDOT);
            AccessByRelativePathTest.fail((String)"A node must never have a property \"..\".");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testGetNodeDotSlashName() throws RepositoryException, NotExecutableException {
        Node parent;
        try {
            int cnt;
            parent = this.testRootNode.getParent();
            NodeIterator it = parent.getNodes(this.testRootNode.getName());
            for (cnt = 0; it.hasNext() && cnt <= 1; ++cnt) {
                it.nextNode();
            }
            if (cnt > 1) {
                throw new NotExecutableException();
            }
        }
        catch (Exception e) {
            throw new NotExecutableException();
        }
        String otherRelPath = DOT + "/" + this.testRootNode.getName();
        AccessByRelativePathTest.assertTrue((boolean)this.testRootNode.isSame((Item)parent.getNode(otherRelPath)));
    }

    public void testGetNodeDotDotSlashName() throws RepositoryException, NotExecutableException {
        String otherRelPath = DOTDOT + "/" + this.testRootNode.getName();
        if (this.testRootNode.getIndex() > 1) {
            otherRelPath = otherRelPath + "[" + this.testRootNode.getIndex() + "]";
        }
        AccessByRelativePathTest.assertTrue((boolean)this.testRootNode.isSame((Item)this.testRootNode.getNode(otherRelPath)));
    }

    public void testGetPropertyDotSlashName() throws RepositoryException {
        Property pt = this.testRootNode.getProperty(this.jcrPrimaryType);
        String otherRelPath = DOT + "/" + this.jcrPrimaryType;
        AccessByRelativePathTest.assertTrue((boolean)pt.isSame((Item)this.testRootNode.getProperty(otherRelPath)));
    }

    public void testGetPropertyDotDotSlashName() throws RepositoryException, NotExecutableException {
        Node parent;
        try {
            parent = this.testRootNode.getParent();
        }
        catch (Exception e) {
            throw new NotExecutableException();
        }
        Property pt = parent.getProperty(this.jcrPrimaryType);
        String otherRelPath = DOTDOT + "/" + this.jcrPrimaryType;
        AccessByRelativePathTest.assertTrue((boolean)pt.isSame((Item)this.testRootNode.getProperty(otherRelPath)));
    }
}

