/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddNewPropertyTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(AddNewPropertyTest.class);
    private String propname;

    protected void tearDown() throws Exception {
        this.testRootNode.refresh(false);
        super.tearDown();
    }

    protected void setUp() throws Exception {
        super.setUp();
        String propName = this.propertyName1;
        while (this.testRootNode.hasProperty(propName)) {
            propName = propName + "_";
        }
        this.propname = propName;
    }

    public void testPropertyAccessibleAfterSave() throws NotExecutableException, RepositoryException {
        Property p;
        try {
            p = this.testRootNode.setProperty(this.propname, "anyValue");
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        String name = p.getName();
        AddNewPropertyTest.assertEquals((String)"Added property must have the original name", (String)name, (String)this.propname);
        AddNewPropertyTest.assertTrue((String)"Accessing the created property again must return the 'same' item.", (boolean)p.isSame((Item)this.testRootNode.getProperty(this.propname)));
    }

    public void testAddPropertyWithNullValue() throws NotExecutableException, RepositoryException, LockException, ConstraintViolationException, VersionException {
        try {
            this.testRootNode.setProperty(this.propname, (Value)null);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testAddPropertyWithNullValues() throws NotExecutableException, RepositoryException, LockException, ConstraintViolationException, VersionException {
        try {
            this.testRootNode.setProperty(this.propname, (Value[])null);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }
}

