/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.ItemImpl;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPropertyTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(AddPropertyTest.class);
    private Node testNode;

    protected void setUp() throws Exception {
        super.setUp();
        this.testNode = this.testRootNode.addNode(this.nodeName1);
        this.testNode.setProperty(this.propertyName1, "existingProp");
        this.testRootNode.save();
    }

    protected void tearDown() throws Exception {
        this.testNode = null;
        super.tearDown();
    }

    private static void assertItemStatus(Item item, int status) throws NotExecutableException {
        if (!(item instanceof ItemImpl)) {
            throw new NotExecutableException("org.apache.jackrabbit.jcr2spi.ItemImpl expected");
        }
        int st = ((ItemImpl)item).getItemState().getStatus();
        AddPropertyTest.assertEquals((String)("Expected status to be " + Status.getName((int)status) + ", was " + Status.getName((int)st)), (int)status, (int)st);
    }

    public void testReplacingProperty() throws RepositoryException, NotExecutableException {
        Property p1 = this.testNode.setProperty(this.propertyName1, "value1");
        p1.remove();
        Property p2 = this.testNode.setProperty(this.propertyName1, "value2");
        p2.remove();
        Property p3 = this.testNode.setProperty(this.propertyName1, "value3");
        this.testNode.save();
        AddPropertyTest.assertTrue((boolean)this.testNode.hasProperty(this.propertyName1));
        AddPropertyTest.assertEquals((String)"value3", (String)this.testNode.getProperty(this.propertyName1).getString());
        AddPropertyTest.assertItemStatus((Item)p1, 8);
        AddPropertyTest.assertItemStatus((Item)p2, 8);
        AddPropertyTest.assertItemStatus((Item)p3, 1);
    }

    public void testReplacingProperty2() throws RepositoryException, NotExecutableException {
        Property p1 = this.testNode.setProperty(this.propertyName2, "value1");
        p1.remove();
        Property p2 = this.testNode.setProperty(this.propertyName2, "value2");
        p2.remove();
        Property p3 = this.testNode.setProperty(this.propertyName2, "value3");
        p3.remove();
        this.testNode.save();
        AddPropertyTest.assertFalse((boolean)this.testNode.hasProperty(this.propertyName2));
        AddPropertyTest.assertItemStatus((Item)p1, 8);
        AddPropertyTest.assertItemStatus((Item)p2, 8);
        AddPropertyTest.assertItemStatus((Item)p3, 8);
    }

    public void testRevertReplacingProperty() throws RepositoryException, NotExecutableException {
        String val = this.testNode.getProperty(this.propertyName1).getString();
        Property p1 = this.testNode.setProperty(this.propertyName1, "value1");
        p1.remove();
        Property p2 = this.testNode.setProperty(this.propertyName1, "value2");
        p2.remove();
        Property p3 = this.testNode.setProperty(this.propertyName1, "value3");
        this.testNode.refresh(false);
        AddPropertyTest.assertTrue((boolean)this.testNode.hasProperty(this.propertyName1));
        AddPropertyTest.assertEquals((String)val, (String)p1.getString());
        AddPropertyTest.assertItemStatus((Item)p1, 1);
        AddPropertyTest.assertItemStatus((Item)p2, 8);
        AddPropertyTest.assertItemStatus((Item)p3, 8);
    }

    public void testAddingProperty() throws RepositoryException, NotExecutableException {
        Property p1 = this.testNode.setProperty(this.propertyName2, "value1");
        p1.remove();
        Property p2 = this.testNode.setProperty(this.propertyName2, "value2");
        p2.remove();
        Property p3 = this.testNode.setProperty(this.propertyName2, "value3");
        this.testNode.save();
        AddPropertyTest.assertTrue((boolean)this.testNode.hasProperty(this.propertyName2));
        AddPropertyTest.assertItemStatus((Item)p1, 8);
        AddPropertyTest.assertItemStatus((Item)p2, 8);
        AddPropertyTest.assertItemStatus((Item)p3, 1);
    }

    public void testAddingProperty2() throws RepositoryException, NotExecutableException {
        Property p1 = this.testNode.setProperty(this.propertyName2, "value1");
        p1.remove();
        Property p2 = this.testNode.setProperty(this.propertyName2, "value2");
        p2.remove();
        Property p3 = this.testNode.setProperty(this.propertyName2, "value3");
        p3.remove();
        this.testNode.save();
        AddPropertyTest.assertFalse((boolean)this.testNode.hasProperty(this.propertyName2));
        AddPropertyTest.assertItemStatus((Item)p1, 8);
        AddPropertyTest.assertItemStatus((Item)p2, 8);
        AddPropertyTest.assertItemStatus((Item)p3, 8);
    }

    public void testRevertAddingProperty() throws RepositoryException, NotExecutableException {
        Property p1 = this.testNode.setProperty(this.propertyName2, "value1");
        p1.remove();
        Property p2 = this.testNode.setProperty(this.propertyName2, "value2");
        p2.remove();
        Property p3 = this.testNode.setProperty(this.propertyName2, "value3");
        this.testNode.refresh(false);
        AddPropertyTest.assertFalse((boolean)this.testNode.hasProperty(this.propertyName2));
        AddPropertyTest.assertItemStatus((Item)p1, 8);
        AddPropertyTest.assertItemStatus((Item)p2, 8);
        AddPropertyTest.assertItemStatus((Item)p3, 8);
    }
}

