/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Random;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.jcr2spi.PropertyImpl;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class BinaryTest
extends AbstractJCRTest {
    private static ByteArrayInputStream generateValue() {
        byte[] data = new byte[0x100000];
        new Random().nextBytes(data);
        return new ByteArrayInputStream(data);
    }

    private static QValue getQValue(Property p) throws ValueFormatException {
        return ((PropertyState)((PropertyImpl)p).getItemState()).getValue();
    }

    private static void assertDisposed(QValue v) {
        try {
            v.getStream();
            BinaryTest.fail((String)"Value should have been disposed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStreamBinary() throws Exception {
        Node test = this.testRootNode.addNode("test");
        Property p = test.setProperty("prop", (InputStream)BinaryTest.generateValue());
        this.checkBinary(p);
        this.superuser.save();
        this.checkBinary(p);
        Session s = this.getHelper().getReadOnlySession();
        try {
            p = s.getNode(this.testRoot).getNode("test").getProperty("prop");
            this.checkBinary(p);
        }
        finally {
            s.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStreamBinary2() throws Exception {
        Node test = this.testRootNode.addNode("test");
        Property p = test.setProperty("prop", (InputStream)BinaryTest.generateValue());
        this.checkBinary(p);
        this.superuser.save();
        this.checkBinary(p);
        Session s = this.getHelper().getReadOnlySession();
        try {
            p = s.getProperty(this.testRoot + "/test/prop");
            this.checkBinary(p);
        }
        finally {
            s.logout();
        }
    }

    public void testBinaryTwiceNewProperty() throws Exception {
        Node test = this.testRootNode.addNode("test");
        Property p = test.setProperty("prop", (InputStream)BinaryTest.generateValue());
        QValue qv1 = BinaryTest.getQValue(p);
        test.setProperty("prop", (InputStream)BinaryTest.generateValue());
        QValue qv2 = BinaryTest.getQValue(p);
        BinaryTest.assertFalse((boolean)qv1.equals(qv2));
        this.superuser.save();
        BinaryTest.assertEquals((Object)qv2, (Object)BinaryTest.getQValue(p));
        BinaryTest.assertDisposed(qv1);
    }

    public void testBinaryTwiceModifiedProperty() throws Exception {
        Node test = this.testRootNode.addNode("test");
        Property p = test.setProperty("prop", (InputStream)BinaryTest.generateValue());
        this.superuser.save();
        test.setProperty("prop", (InputStream)BinaryTest.generateValue());
        QValue qv1 = BinaryTest.getQValue(p);
        test.setProperty("prop", (InputStream)BinaryTest.generateValue());
        QValue qv2 = BinaryTest.getQValue(p);
        BinaryTest.assertFalse((boolean)qv1.equals(qv2));
        this.superuser.save();
        BinaryTest.assertEquals((Object)qv2, (Object)BinaryTest.getQValue(p));
        BinaryTest.assertDisposed(qv1);
    }

    public void testBinaryTwiceIntermediateSave() throws Exception {
        Node test = this.testRootNode.addNode("test");
        Property p = test.setProperty("prop", (InputStream)BinaryTest.generateValue());
        QValue qv1 = BinaryTest.getQValue(p);
        this.superuser.save();
        test.setProperty("prop", (InputStream)BinaryTest.generateValue());
        QValue qv2 = BinaryTest.getQValue(p);
        BinaryTest.assertFalse((boolean)qv1.equals(qv2));
        this.superuser.save();
        BinaryTest.assertEquals((Object)qv2, (Object)BinaryTest.getQValue(p));
        BinaryTest.assertDisposed(qv1);
    }

    public void testRevertSettingExistingBinary() throws Exception {
        Node test = this.testRootNode.addNode("test");
        Binary b = this.superuser.getValueFactory().createBinary((InputStream)BinaryTest.generateValue());
        Property p = test.setProperty("prop", b);
        QValue qv1 = BinaryTest.getQValue(p);
        this.superuser.save();
        Binary b2 = this.superuser.getValueFactory().createBinary((InputStream)BinaryTest.generateValue());
        test.setProperty("prop", b2);
        QValue qv2 = BinaryTest.getQValue(p);
        BinaryTest.assertFalse((boolean)qv1.equals(qv2));
        this.superuser.refresh(false);
        BinaryTest.assertEquals((Object)qv1, (Object)BinaryTest.getQValue(p));
        BinaryTest.assertSame((Object)qv1, (Object)BinaryTest.getQValue(p));
        BinaryTest.assertFalse((boolean)qv2.equals(BinaryTest.getQValue(p)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkBinary(Property p) throws Exception {
        for (int i = 0; i < 3; ++i) {
            Binary bin = p.getBinary();
            try {
                bin.read(new byte[1], 0L);
                continue;
            }
            finally {
                bin.dispose();
            }
        }
    }
}

