/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.jcr2spi.ItemImpl;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalModificationTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(ExternalModificationTest.class);
    private Node destParentNode;
    private Node refNode;
    private Session testSession;

    protected void setUp() throws Exception {
        super.setUp();
        this.destParentNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.refNode = this.testRootNode.addNode(this.nodeName2, this.getProperty("nodetype2"));
        this.refNode.addMixin(this.mixReferenceable);
        this.testRootNode.save();
        this.testSession = this.getHelper().getReadWriteSession();
    }

    protected void tearDown() throws Exception {
        if (this.testSession != null) {
            this.testSession.logout();
            this.testSession = null;
        }
        this.destParentNode = null;
        this.refNode = null;
        super.tearDown();
    }

    private static boolean isItemStatus(Item item, int status) throws NotExecutableException {
        if (!(item instanceof ItemImpl)) {
            throw new NotExecutableException("org.apache.jackrabbit.jcr2spi.ItemImpl expected");
        }
        int st = ((ItemImpl)item).getItemState().getStatus();
        return st == status;
    }

    private static void assertItemStatus(Item item, int status) throws NotExecutableException {
        if (!(item instanceof ItemImpl)) {
            throw new NotExecutableException("org.apache.jackrabbit.jcr2spi.ItemImpl expected");
        }
        int st = ((ItemImpl)item).getItemState().getStatus();
        ExternalModificationTest.assertEquals((String)("Expected status to be " + Status.getName((int)status) + ", was " + Status.getName((int)st)), (int)status, (int)st);
    }

    public void testMovedReferenceableNode() throws RepositoryException, NotExecutableException {
        Node refNode2 = (Node)this.testSession.getItem(this.refNode.getPath());
        this.superuser.move(this.refNode.getPath(), this.destParentNode.getPath() + "/" + this.nodeName2);
        this.superuser.save();
        try {
            refNode2.setProperty(this.propertyName1, "test");
            this.testSession.save();
            ExternalModificationTest.assertTrue((boolean)this.testSession.getItem(this.destParentNode.getPath()).isSame((Item)this.refNode.getParent()));
        }
        catch (InvalidItemStateException e) {
            log.debug(e.getMessage());
        }
    }

    public void testRefreshMovedReferenceableNode() throws RepositoryException, NotExecutableException {
        Node refNode2 = (Node)this.testSession.getItem(this.refNode.getPath());
        this.superuser.move(this.refNode.getPath(), this.destParentNode.getPath() + "/" + this.nodeName2);
        this.superuser.save();
        try {
            refNode2.refresh(true);
            Node parent = refNode2.getParent();
            if (parent.isSame(this.testSession.getItem(this.destParentNode.getPath()))) {
                ExternalModificationTest.assertItemStatus((Item)refNode2, 1);
            } else {
                ExternalModificationTest.assertItemStatus((Item)refNode2, 8);
            }
        }
        catch (InvalidItemStateException e) {
            log.debug(e.getMessage());
            ExternalModificationTest.assertItemStatus((Item)refNode2, 8);
        }
    }

    public void testConflictingAddMixin() throws RepositoryException, NotExecutableException {
        Node refNode2 = (Node)this.testSession.getItem(this.refNode.getPath());
        refNode2.addMixin(this.mixLockable);
        this.superuser.move(this.refNode.getPath(), this.destParentNode.getPath() + "/" + this.nodeName2);
        this.superuser.save();
        try {
            refNode2.refresh(true);
            Node parent = refNode2.getParent();
            if (parent.isSame(this.testSession.getItem(this.destParentNode.getPath()))) {
                ExternalModificationTest.assertItemStatus((Item)refNode2, 2);
            } else if (!ExternalModificationTest.isItemStatus((Item)refNode2, 2)) {
                ExternalModificationTest.assertItemStatus((Item)refNode2, 6);
            }
        }
        catch (InvalidItemStateException e) {
            log.debug(e.getMessage());
            ExternalModificationTest.assertItemStatus((Item)refNode2, 6);
            Node refAgain = this.testSession.getNodeByUUID(this.refNode.getUUID());
            ExternalModificationTest.assertTrue((boolean)refAgain.getParent().isSame(this.testSession.getItem(this.destParentNode.getPath())));
            ExternalModificationTest.assertFalse((boolean)refAgain.isNodeType(this.mixLockable));
        }
    }

    public void testStaleDestroyed() throws RepositoryException, NotExecutableException {
        Node refNode2 = (Node)this.testSession.getItem(this.refNode.getPath());
        refNode2.addMixin(this.mixLockable);
        this.superuser.move(this.refNode.getPath(), this.destParentNode.getPath() + "/" + this.nodeName2);
        this.superuser.save();
        this.testSession.getItem(this.destParentNode.getPath() + "/" + this.nodeName2);
        ExternalModificationTest.assertItemStatus((Item)refNode2, 6);
        try {
            refNode2.refresh(false);
            ExternalModificationTest.fail();
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testStaleDestroyed2() throws RepositoryException, NotExecutableException {
        Node refNode2 = (Node)this.testSession.getItem(this.refNode.getPath());
        refNode2.addMixin(this.mixLockable);
        this.superuser.move(this.refNode.getPath(), this.destParentNode.getPath() + "/" + this.nodeName2);
        this.superuser.save();
        this.testSession.getItem(this.destParentNode.getPath() + "/" + this.nodeName2);
        ExternalModificationTest.assertItemStatus((Item)refNode2, 6);
        this.testSession.refresh(false);
        ExternalModificationTest.assertItemStatus((Item)refNode2, 8);
    }

    public void testStaleDestroyed3() throws RepositoryException, NotExecutableException {
        String uuid = this.refNode.getUUID();
        Node refNode2 = (Node)this.testSession.getItem(this.refNode.getPath());
        ExternalModificationTest.assertTrue((boolean)refNode2.isSame((Item)this.testSession.getNodeByUUID(uuid)));
        refNode2.addMixin(this.mixLockable);
        String srcPath = this.refNode.getPath();
        String destPath = this.destParentNode.getPath() + "/" + this.nodeName2;
        this.superuser.move(srcPath, destPath);
        this.superuser.save();
        this.testSession.getItem(destPath);
        ExternalModificationTest.assertItemStatus((Item)refNode2, 6);
        Node n = this.testSession.getNodeByUUID(uuid);
        ExternalModificationTest.assertTrue((boolean)n.isSame(this.testSession.getItem(destPath)));
        ExternalModificationTest.assertTrue((boolean)refNode2.isSame(this.testSession.getItem(srcPath)));
    }

    public void testExternalRemoval() throws RepositoryException, NotExecutableException {
        String uuid = this.refNode.getUUID();
        Node refNode2 = this.testSession.getNodeByUUID(uuid);
        String srcPath = this.refNode.getPath();
        String destPath = this.destParentNode.getPath() + "/" + this.nodeName2;
        this.superuser.move(srcPath, destPath);
        this.superuser.save();
        try {
            refNode2.refresh(true);
            Node node = refNode2.getParent();
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        ExternalModificationTest.assertItemStatus((Item)refNode2, 8);
        Node n = this.testSession.getNodeByUUID(uuid);
        ExternalModificationTest.assertTrue((boolean)n.isSame(this.testSession.getItem(destPath)));
    }

    public void testExternalRemoval2() throws RepositoryException, NotExecutableException {
        Node childN = this.refNode.addNode(this.nodeName3);
        Property p = childN.setProperty(this.propertyName1, "anyvalue");
        this.refNode.save();
        String uuid = this.refNode.getUUID();
        Node refNode2 = this.testSession.getNodeByUUID(uuid);
        Node c2 = (Node)this.testSession.getItem(childN.getPath());
        Property p2 = (Property)this.testSession.getItem(p.getPath());
        p2.remove();
        String srcPath = this.refNode.getPath();
        String destPath = this.destParentNode.getPath() + "/" + this.nodeName2;
        this.superuser.move(srcPath, destPath);
        this.superuser.save();
        try {
            refNode2.refresh(true);
            Node node = refNode2.getParent();
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        ExternalModificationTest.assertItemStatus((Item)refNode2, 8);
        ExternalModificationTest.assertItemStatus((Item)c2, 6);
        ExternalModificationTest.assertItemStatus((Item)p2, 8);
    }

    public void testExternalRemoval3() throws RepositoryException, NotExecutableException {
        Node childN = this.refNode.addNode(this.nodeName3);
        Property p = childN.setProperty(this.propertyName1, "anyvalue");
        this.refNode.save();
        String uuid = this.refNode.getUUID();
        Node refNode2 = this.testSession.getNodeByUUID(uuid);
        Node c2 = (Node)this.testSession.getItem(childN.getPath());
        Property p2 = (Property)this.testSession.getItem(p.getPath());
        p2.setValue("changedValue");
        String srcPath = this.refNode.getPath();
        String destPath = this.destParentNode.getPath() + "/" + this.nodeName2;
        this.superuser.move(srcPath, destPath);
        this.superuser.save();
        try {
            refNode2.refresh(true);
            Node node = refNode2.getParent();
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        ExternalModificationTest.assertItemStatus((Item)refNode2, 8);
        ExternalModificationTest.assertItemStatus((Item)c2, 8);
        ExternalModificationTest.assertItemStatus((Item)p2, 6);
        ExternalModificationTest.assertEquals((String)"changedValue", (String)p2.getString());
    }

    public void testNewItemsUponStaleDestroyed() throws RepositoryException, NotExecutableException {
        String uuid = this.refNode.getUUID();
        Node refNode2 = (Node)this.testSession.getItem(this.refNode.getPath());
        refNode2.addMixin(this.mixLockable);
        Node childN = refNode2.addNode(this.nodeName3);
        String childNPath = childN.getPath();
        Property childP = refNode2.setProperty(this.propertyName2, "someValue");
        String childPPath = childP.getPath();
        String destPath = this.destParentNode.getPath() + "/" + this.nodeName2;
        this.superuser.move(this.refNode.getPath(), destPath);
        this.superuser.save();
        this.testSession.refresh(true);
        this.testSession.getItem(destPath);
        ExternalModificationTest.assertItemStatus((Item)refNode2, 6);
        ExternalModificationTest.assertItemStatus((Item)refNode2.getProperty(this.jcrMixinTypes), 6);
        ExternalModificationTest.assertItemStatus((Item)childN, 4);
        ExternalModificationTest.assertItemStatus((Item)childP, 4);
        ExternalModificationTest.assertItemStatus((Item)childN.getProperty(this.jcrPrimaryType), 4);
        ExternalModificationTest.assertTrue((boolean)this.testSession.itemExists(childNPath));
        ExternalModificationTest.assertTrue((boolean)childN.isSame(this.testSession.getItem(childNPath)));
        ExternalModificationTest.assertTrue((boolean)this.testSession.itemExists(childPPath));
        ExternalModificationTest.assertTrue((boolean)childP.isSame(this.testSession.getItem(childPPath)));
        this.testSession.refresh(false);
        ExternalModificationTest.assertItemStatus((Item)childN, 8);
        ExternalModificationTest.assertItemStatus((Item)childP, 8);
        ExternalModificationTest.assertFalse((boolean)this.testSession.itemExists(childNPath));
        ExternalModificationTest.assertFalse((boolean)this.testSession.itemExists(childPPath));
    }

    public void testChildItemsUponStaleDestroyed() throws RepositoryException, NotExecutableException {
        Node cNode = this.refNode.addNode(this.nodeName3);
        Node cNode2 = cNode.addNode(this.nodeName4);
        this.refNode.save();
        String uuid = this.refNode.getUUID();
        Node refNode2 = (Node)this.testSession.getItem(this.refNode.getPath());
        refNode2.addMixin(this.mixLockable);
        Node child = (Node)this.testSession.getItem(cNode.getPath());
        Node child2 = (Node)this.testSession.getItem(cNode2.getPath());
        Node child3 = child2.addNode(this.nodeName4);
        String child3Path = child3.getPath();
        String destPath = this.destParentNode.getPath() + "/" + this.nodeName2;
        this.superuser.move(this.refNode.getPath(), destPath);
        this.superuser.save();
        this.testSession.refresh(true);
        this.testSession.getItem(destPath);
        ExternalModificationTest.assertItemStatus((Item)refNode2, 6);
        ExternalModificationTest.assertItemStatus((Item)refNode2.getProperty(this.jcrMixinTypes), 6);
        ExternalModificationTest.assertItemStatus((Item)child, 8);
        ExternalModificationTest.assertItemStatus((Item)child2, 6);
        ExternalModificationTest.assertItemStatus((Item)child3, 4);
        ExternalModificationTest.assertItemStatus((Item)child3.getProperty(this.jcrPrimaryType), 4);
        this.testSession.refresh(false);
        ExternalModificationTest.assertItemStatus((Item)child2, 8);
        ExternalModificationTest.assertItemStatus((Item)child3, 8);
    }

    public void testUnmodifiedAncestorRemoved() throws RepositoryException, NotExecutableException {
        String uuid = this.refNode.getUUID();
        Node n3 = this.refNode.addNode(this.nodeName3, this.testNodeType);
        this.refNode.save();
        Node refNode2 = (Node)this.testSession.getItem(this.refNode.getPath());
        Node node3 = (Node)this.testSession.getItem(n3.getPath());
        node3.addMixin(this.mixLockable);
        Node childN = node3.addNode(this.nodeName3);
        String childNPath = childN.getPath();
        Property childP = node3.setProperty(this.propertyName2, "someValue");
        String childPPath = childP.getPath();
        String destPath = this.destParentNode.getPath() + "/" + this.nodeName2;
        this.superuser.move(this.refNode.getPath(), destPath);
        this.superuser.save();
        this.testSession.refresh(true);
        this.testSession.getItem(destPath);
        ExternalModificationTest.assertItemStatus((Item)refNode2, 8);
        ExternalModificationTest.assertItemStatus((Item)node3, 6);
        ExternalModificationTest.assertItemStatus((Item)childN, 4);
        ExternalModificationTest.assertItemStatus((Item)childP, 4);
        ExternalModificationTest.assertFalse((boolean)this.testSession.itemExists(childNPath));
        ExternalModificationTest.assertFalse((boolean)this.testSession.itemExists(childPPath));
        this.testSession.refresh(false);
        ExternalModificationTest.assertItemStatus((Item)node3, 8);
        ExternalModificationTest.assertItemStatus((Item)childN, 8);
        ExternalModificationTest.assertItemStatus((Item)childP, 8);
    }
}

