/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.jcr2spi.AbstractJCR2SPITest;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.commons.ItemInfoBuilder;
import org.apache.jackrabbit.spi.commons.iterator.Iterators;
import org.apache.jackrabbit.spi.commons.iterator.Predicate;

public class GetItemsTest
extends AbstractJCR2SPITest {
    private Session session;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.session = this.repository.login("default");
    }

    @Override
    protected void initInfosStore(ItemInfoBuilder.NodeInfoBuilder builder) throws RepositoryException {
        builder.createNodeInfo("node1").createNodeInfo("node11").build().createNodeInfo("node12").build().createNodeInfo("node13").build().createPropertyInfo("property11", "value11").build().createPropertyInfo("property12", "value12").build().build().createNodeInfo("node2").createNodeInfo("node21").createNodeInfo("node211").createNodeInfo("node2111").createNodeInfo("node21111").createNodeInfo("node211111").createNodeInfo("node2111111").build().build().build().build().build().build().build().createNodeInfo("node3").build().build();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testGetItemInfosRootFirst() throws RepositoryException {
        GetItemsTest.assertTrue((this.session.getRootNode().getDepth() == 0 ? 1 : 0) != 0);
        this.checkHierarchy();
    }

    public void testGetItemInfosDeepFirst() throws RepositoryException {
        String targetPath = "/node2/node21/node211/node2111/node21111/node211111/node2111111";
        GetItemsTest.assertEquals((String)"/node2/node21/node211/node2111/node21111/node211111/node2111111", (String)this.session.getItem("/node2/node21/node211/node2111/node21111/node211111/node2111111").getPath());
        this.checkHierarchy();
    }

    private void checkHierarchy() throws PathNotFoundException, RepositoryException, ItemNotFoundException, AccessDeniedException {
        Iterator<ItemInfo> itemInfos = this.itemInfoStore.getItemInfos();
        while (itemInfos.hasNext()) {
            ItemInfo itemInfo = itemInfos.next();
            String jcrPath = GetItemsTest.toJCRPath(itemInfo.getPath());
            Item item = this.session.getItem(jcrPath);
            GetItemsTest.assertEquals((String)jcrPath, (String)item.getPath());
            if (item.getDepth() <= 0) continue;
            Node parent = item.getParent();
            if (item.isNode()) {
                GetItemsTest.assertTrue((boolean)item.isSame((Item)parent.getNode(item.getName())));
                continue;
            }
            GetItemsTest.assertTrue((boolean)item.isSame((Item)parent.getProperty(item.getName())));
        }
    }

    @Override
    protected QNodeDefinition createRootNodeDefinition() {
        GetItemsTest.fail((String)"Not implemented");
        return null;
    }

    @Override
    public Iterator<ChildInfo> getChildInfos(SessionInfo sessionInfo, NodeId parentId) throws RepositoryException {
        GetItemsTest.fail((String)"Not implemented");
        return null;
    }

    public Iterator<ItemInfo> getItemInfos(SessionInfo sessionInfo, final ItemId itemId) throws RepositoryException {
        return Iterators.iteratorChain((Iterator)Iterators.singleton((Object)this.itemInfoStore.getItemInfo(itemId)), (Iterator)Iterators.filterIterator(this.itemInfoStore.getItemInfos(), (Predicate)new Predicate<ItemInfo>(){

            public boolean evaluate(ItemInfo info) {
                return !itemId.equals(info.getId());
            }
        }));
    }

    @Override
    public NodeInfo getNodeInfo(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        return this.itemInfoStore.getNodeInfo(nodeId);
    }

    @Override
    public PropertyInfo getPropertyInfo(SessionInfo sessionInfo, PropertyId propertyId) throws ItemNotFoundException {
        return this.itemInfoStore.getPropertyInfo(propertyId);
    }
}

